/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.IUpdateListener;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.UpdateManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Argument;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;

public class VariableManager
extends SessionObject
implements ICDIVariableManager,
IUpdateListener {
    List variableList = Collections.synchronizedList(new ArrayList());
    boolean autoupdate = true;

    public VariableManager(Session session) {
        super(session);
    }

    public Variable getVariable(String varName) {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                return vars[i];
            }
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableObject v) throws CDIException {
        StackFrame stack = v.getStackFrame();
        String name = v.getName();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(name)) {
                ICDIStackFrame frame = vars[i].getStackFrame();
                if (stack == null && frame == null) {
                    return vars[i];
                }
                if (frame != null && stack != null && frame.equals((ICDIStackFrame)stack) && vars[i].getVariableObject().getPosition() == position && vars[i].getVariableObject().getStackDepth() == depth) {
                    return vars[i];
                }
            }
            ++i;
        }
        return null;
    }

    void addVariable(Variable var) {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            String name = vars[i].getMIVar().getVarName();
            if (name.equals(var.getMIVar().getVarName())) {
                return;
            }
            ++i;
        }
        this.variableList.add(var);
    }

    Variable[] getVariables() {
        return this.variableList.toArray(new Variable[0]);
    }

    public Variable createVariable(VariableObject v, MIVar mivar) throws CDIException {
        Variable variable = new Variable(v, mivar);
        this.addVariable(variable);
        return variable;
    }

    void removeMIVar(MIVar miVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            mi.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void removeVariable(String varName) throws CDIException {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                this.variableList.remove(vars[i]);
                this.removeMIVar(vars[i].getMIVar());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIArgument createArgument(ICDIArgumentObject a) throws CDIException {
        if (!(a instanceof ArgumentObject)) throw new CDIException("Wrong variable type");
        ArgumentObject argObj = (ArgumentObject)a;
        Variable variable = this.findVariable(argObj);
        Argument argument = null;
        if (variable != null && variable instanceof Argument) {
            argument = (Argument)variable;
        }
        if (argument != null) return argument;
        String name = argObj.getName();
        StackFrame stack = argObj.getStackFrame();
        Session session = (Session)this.getSession();
        Thread currentThread = null;
        StackFrame currentFrame = null;
        if (stack != null) {
            ICDITarget currentTarget = session.getCurrentTarget();
            currentThread = (Thread)currentTarget.getCurrentThread();
            currentFrame = (StackFrame)currentThread.getCurrentStackFrame();
            ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
        }
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                argument = new Argument(argObj, info.getMIVar());
                this.addVariable(argument);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var15_15 = null;
            if (currentThread == null) return argument;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (currentThread == null) throw throwable;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return argument;
    }

    public ICDIArgumentObject getArgumentObject(ICDIStackFrame stack, String name) throws CDIException {
        ICDIArgumentObject[] argsObjects = this.getArgumentObjects(stack);
        int i = 0;
        while (i < argsObjects.length) {
            if (argsObjects[i].getName().equals(name)) {
                return argsObjects[i];
            }
            ++i;
        }
        return null;
    }

    public ICDIArgumentObject[] getArgumentObjects(ICDIStackFrame frame) throws CDIException {
        if (!(frame instanceof StackFrame)) {
            return new ICDIArgumentObject[0];
        }
        ArrayList<ArgumentObject> argObjects = new ArrayList<ArgumentObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        Thread currentThread = (Thread)currentTarget.getCurrentThread();
        StackFrame currentFrame = (StackFrame)currentThread.getCurrentStackFrame();
        ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
        try {
            block8: {
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    int depth = frame.getThread().getStackFrameCount();
                    int level = frame.getLevel();
                    MIStackListArguments listArgs = factory.createMIStackListArguments(false, level, level);
                    MIArg[] args = null;
                    mi.postCommand(listArgs);
                    MIStackListArgumentsInfo info = listArgs.getMIStackListArgumentsInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    if (miFrames != null && miFrames.length == 1) {
                        args = miFrames[0].getArgs();
                    }
                    if (args == null) break block8;
                    ICDITarget target = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        ArgumentObject arg = new ArgumentObject(target, args[i].getName(), (StackFrame)frame, args.length - i, depth);
                        argObjects.add(arg);
                        ++i;
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            Object var19_19 = null;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            currentThread.setCurrentStackFrame(currentFrame);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame);
        return argObjects.toArray(new ICDIArgumentObject[0]);
    }

    public ICDIVariableObject getVariableObject(ICDIStackFrame stack, String name) throws CDIException {
        ICDIVariableObject[] varObjects = this.getVariableObjects(stack);
        int i = 0;
        while (i < varObjects.length) {
            if (varObjects[i].getName().equals(name)) {
                return varObjects[i];
            }
            ++i;
        }
        return null;
    }

    public ICDIVariableObject getVariableObject(String filename, String function, String name) throws CDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        ICDITarget target = this.getSession().getCurrentTarget();
        return new VariableObject(target, buffer.toString(), null, 0, 0);
    }

    public ICDIVariableObject[] getVariableObjects(ICDIStackFrame frame) throws CDIException {
        if (!(frame instanceof StackFrame)) {
            return new ICDIVariableObject[0];
        }
        ArrayList<VariableObject> varObjects = new ArrayList<VariableObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        Thread currentThread = (Thread)currentTarget.getCurrentThread();
        StackFrame currentFrame = (StackFrame)currentThread.getCurrentStackFrame();
        ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
        try {
            block7: {
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    int depth = frame.getThread().getStackFrameCount();
                    MIArg[] args = null;
                    MIStackListLocals locals = factory.createMIStackListLocals(false);
                    mi.postCommand(locals);
                    MIStackListLocalsInfo info = locals.getMIStackListLocalsInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    args = info.getLocals();
                    if (args == null) break block7;
                    ICDITarget target = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        VariableObject varObj = new VariableObject(target, args[i].getName(), (StackFrame)frame, args.length - i, depth);
                        varObjects.add(varObj);
                        ++i;
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return varObjects.toArray(new ICDIVariableObject[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIVariable createVariable(ICDIVariableObject v) throws CDIException {
        if (!(v instanceof VariableObject)) throw new CDIException("Wrong variable type");
        VariableObject varObj = (VariableObject)v;
        Variable variable = this.findVariable(varObj);
        if (variable != null) return variable;
        String name = varObj.getName();
        Session session = (Session)this.getSession();
        StackFrame stack = varObj.getStackFrame();
        Thread currentThread = null;
        StackFrame currentFrame = null;
        if (stack != null) {
            ICDITarget currentTarget = session.getCurrentTarget();
            currentThread = (Thread)currentTarget.getCurrentThread();
            currentFrame = (StackFrame)currentThread.getCurrentStackFrame();
            ((Thread)stack.getThread()).setCurrentStackFrame(stack, false);
        }
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var);
                MIVarCreateInfo info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                variable = new Variable(varObj, info.getMIVar());
                this.addVariable(variable);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var14_14 = null;
            if (currentThread == null) return variable;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (currentThread == null) throw throwable;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return variable;
    }

    public void destroyVariable(ICDIVariable var) throws CDIException {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            MIVarChangedEvent change = new MIVarChangedEvent(0, variable.getMIVar().getVarName(), false);
            Session session = (Session)this.getSession();
            MISession mi = session.getMISession();
            mi.fireEvent(change);
        }
    }

    public void changeList(MIVarChange[] changes) {
        ArrayList<MIVarChangedEvent> eventList = new ArrayList<MIVarChangedEvent>(changes.length);
        int i = 0;
        while (i < changes.length) {
            String varName = changes[i].getVarName();
            Variable variable = this.getVariable(varName);
            if (variable != null) {
                eventList.add(new MIVarChangedEvent(0, varName, changes[i].isInScope()));
            }
            ++i;
        }
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        UpdateManager mgr = session.getUpdateManager();
        mgr.update();
    }
}

