/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;

public class CreatedEvent
implements ICDICreatedEvent {
    Session session;
    ICDIObject source;

    public CreatedEvent(Session s, MIBreakpointCreatedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(number);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCurrentTarget());
    }

    public CreatedEvent(Session s, MIVarCreatedEvent var) {
        this.session = s;
        VariableManager mgr = (VariableManager)this.session.getVariableManager();
        String varName = var.getVarName();
        Variable variable = mgr.getVariable(varName);
        this.source = variable != null ? variable : new CObject(this.session.getCurrentTarget());
    }

    public CreatedEvent(Session s, MIRegisterCreatedEvent var) {
        this.session = s;
        RegisterManager mgr = (RegisterManager)this.session.getRegisterManager();
        int regno = var.getNumber();
        Register reg = null;
        try {
            reg = mgr.getRegister(regno);
        }
        catch (CDIException e) {
            // empty catch block
        }
        this.source = reg != null ? reg : new CObject(this.session.getCurrentTarget());
    }

    public CreatedEvent(Session s, MIThreadCreatedEvent ethread) {
        this.session = s;
        Target target = (Target)this.session.getCurrentTarget();
        ICDIThread thread = target.getThread(ethread.getId());
        this.source = thread != null ? thread : new CObject(this.session.getCurrentTarget());
    }

    public CreatedEvent(Session s, MIMemoryCreatedEvent mblock) {
        this.session = s;
        MemoryManager mgr = (MemoryManager)this.session.getMemoryManager();
        MemoryBlock[] blocks = mgr.listMemoryBlocks();
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i].getStartAddress() == mblock.getAddress() && blocks[i].getLength() == mblock.getLength()) {
                this.source = blocks[i];
                break;
            }
            ++i;
        }
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public CreatedEvent(Session s, MISharedLibCreatedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String name = slib.getName();
        ICDISharedLibrary lib = mgr.getSharedLibrary(name);
        this.source = lib != null ? lib : new CObject(this.session.getCurrentTarget());
    }

    public CreatedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

