/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class DestroyedEvent
implements ICDIDestroyedEvent {
    Session session;
    ICDIObject source;

    public DestroyedEvent(Session s, MIThreadExitEvent ethread) {
        this.session = s;
        this.source = new Thread(this.session.getCurrentTarget(), ethread.getId());
    }

    public DestroyedEvent(Session s, MIVarChangedEvent var) {
        this.session = s;
        VariableManager mgr = (VariableManager)this.session.getVariableManager();
        String varName = var.getVarName();
        Variable variable = mgr.getVariable(varName);
        if (variable != null) {
            this.source = variable;
            try {
                mgr.removeVariable(variable.getMIVar().getVarName());
            }
            catch (CDIException e) {}
        } else {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public DestroyedEvent(Session s, MIBreakpointDeletedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(number);
        if (breakpoint != null) {
            this.source = breakpoint;
            mgr.deleteBreakpoint(number);
        } else {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public DestroyedEvent(Session s, MISharedLibUnloadedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String name = slib.getName();
        ICDISharedLibrary lib = mgr.getUnloadedLibrary(name);
        if (lib != null) {
            mgr.removeFromUnloadedList(name);
            this.source = lib;
        } else {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public DestroyedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public DestroyedEvent(Session s) {
        this.session = s;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

