/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;

public class Value
extends CObject
implements ICDIValue {
    Variable variable;

    public Value(Variable v) {
        super(v.getTarget());
        this.variable = v;
    }

    public String getTypeName() throws CDIException {
        return this.variable.getTypeName();
    }

    public String getValueString() throws CDIException {
        String result = "";
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarEvaluateExpression var = factory.createMIVarEvaluateExpression(this.variable.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarEvaluateExpressionInfo info = var.getMIVarEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            result = info.getValue();
        }
        catch (MIException e) {
            // empty catch block
        }
        return result;
    }

    public int getChildrenNumber() throws CDIException {
        return this.variable.getMIVar().getNumChild();
    }

    public boolean hasChildren() throws CDIException {
        return this.getChildrenNumber() > 0;
    }

    public ICDIVariable[] getVariables() throws CDIException {
        ICDIVariable[] variables = null;
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        VariableManager mgr = (VariableManager)session.getVariableManager();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.variable.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIVar[] vars = info.getMIVars();
            variables = new Variable[vars.length];
            int i = 0;
            while (i < vars.length) {
                VariableObject varObj = new VariableObject(this.getTarget(), vars[i].getExp(), (StackFrame)this.variable.getStackFrame(), this.variable.getVariableObject().getPosition(), this.variable.getVariableObject().getStackDepth());
                variables[i] = mgr.createVariable(varObj, vars[i]);
                ++i;
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return variables;
    }
}

