/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarSetFormat;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public class Variable
extends CObject
implements ICDIVariable {
    MIVar miVar;
    Value value;
    VariableObject varObj;

    public Variable(VariableObject obj, MIVar v) {
        super(obj.getTarget());
        this.miVar = v;
        this.varObj = obj;
    }

    public MIVar getMIVar() {
        return this.miVar;
    }

    public VariableObject getVariableObject() {
        return this.varObj;
    }

    public String getName() throws CDIException {
        return this.varObj.getName();
    }

    public String getTypeName() throws CDIException {
        return this.miVar.getType();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            this.value = new Value(this);
        }
        return this.value;
    }

    public void setValue(ICDIValue value) throws CDIException {
        this.setValue(value.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.miVar.getVarName(), expression);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MIVarChangedEvent change = new MIVarChangedEvent(var.getToken(), this.miVar.getVarName(), true);
        mi.fireEvent(change);
    }

    public boolean isEditable() throws CDIException {
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarShowAttributes var = factory.createMIVarShowAttributes(this.miVar.getVarName());
        try {
            mi.postCommand(var);
            MIVarShowAttributesInfo info = var.getMIVarShowAttributesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.isEditable();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void setFormat(int format) throws CDIException {
        int fmt = Format.toMIFormat(format);
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarSetFormat var = factory.createMIVarSetFormat(this.miVar.getVarName(), fmt);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean equals(ICDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.miVar.getVarName().equals(variable.getMIVar().getVarName());
        }
        return super.equals(var);
    }

    public ICDIStackFrame getStackFrame() throws CDIException {
        return this.varObj.getStackFrame();
    }
}

