/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIThreadSelectInfo
extends MIInfo {
    int threadId;
    MIFrame frame;

    public MIThreadSelectInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public int getNewThreadId() {
        return this.threadId;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("new-thread-id")) {
                    value = results[i].getMIValue();
                    if (value instanceof MIConst) {
                        String str = ((MIConst)value).getCString();
                        try {
                            this.threadId = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

