/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParserConfiguration;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.ui.wizards.IWizardTab;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class BinaryParserBlock
implements IWizardTab {
    private static final String PREFIX = "BinaryParserBlock";
    private static final String LABEL = "BinaryParserBlock.label";
    private static String[][] radios;
    private IProject project;
    protected RadioButtonsArea radioButtons;
    private String defaultFormat;
    IValidation page;

    public BinaryParserBlock(IValidation valid) {
        this(valid, null);
    }

    public BinaryParserBlock(IValidation valid, IProject p) {
        this.page = valid;
        this.project = p;
        IBinaryParserConfiguration[] configs = CCorePlugin.getDefault().getBinaryParserConfigurations();
        radios = new String[configs.length][2];
        int i = 0;
        while (i < configs.length) {
            BinaryParserBlock.radios[i] = new String[]{configs[i].getName(), configs[i].getFormat()};
            ++i;
        }
        CoreModel model = CCorePlugin.getDefault().getCoreModel();
        this.defaultFormat = this.project == null ? model.getDefaultBinaryParserFormat() : model.getBinaryParserFormat(this.project);
    }

    public String getLabel() {
        return "Binary Parser";
    }

    public Image getImage() {
        return null;
    }

    public Composite getControl(Composite parent) {
        Composite composite = ControlFactory.createComposite(parent, 1);
        this.radioButtons = new RadioButtonsArea(composite, "Parsers", 1, radios);
        this.radioButtons.setEnabled(true);
        if (this.defaultFormat != null) {
            this.radioButtons.setSelectValue(this.defaultFormat);
        }
        return composite;
    }

    public boolean isValid() {
        return true;
    }

    public void setVisible(boolean visible) {
    }

    public void doRun(IProject project, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Parsers", 1);
        CoreModel model = CCorePlugin.getDefault().getCoreModel();
        String format = this.radioButtons.getSelectedValue();
        if (!(format == null || this.defaultFormat != null && format.equals(this.defaultFormat))) {
            model.setBinaryParserFormat(project, format, monitor);
            this.defaultFormat = format;
        }
    }
}

