/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.core.IState;
import org.eclipse.cdt.debug.core.cdi.ICDIExitInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDTDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_QUALIFIED_NAMES = "DISPLAY_QUALIFIED_NAMES";
    protected HashMap fAttributes = new HashMap(3);
    private static CDTDebugModelPresentation fInstance = null;
    static /* synthetic */ Class class$0;

    public CDTDebugModelPresentation() {
        fInstance = this;
    }

    public static CDTDebugModelPresentation getDefault() {
        return fInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value != null) {
            this.fAttributes.put(attribute, value);
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        IFile file = null;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            file = (IFile)resource;
        }
        if (element instanceof IFile) {
            file = (IFile)element;
        }
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorRegistry registry;
        IEditorDescriptor descriptor;
        if (input != null && (descriptor = (registry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(input.getName())) != null) {
            return descriptor.getId();
        }
        return null;
    }

    public Image getImage(Object element) {
        return super.getImage(element);
    }

    public String getText(Object element) {
        boolean showQualified = this.isShowQualifiedNames();
        StringBuffer label = new StringBuffer();
        try {
            if (element instanceof IVariable) {
                label.append(this.getVariableText((IVariable)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            } else if (element instanceof IThread) {
                label.append(this.getThreadText((IThread)element, showQualified));
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, "<terminated>");
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, "<disconnected>");
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException debugException) {
            return "<not_responding>";
        }
        return null;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.fAttributes.get(DISPLAY_QUALIFIED_NAMES);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        if (target instanceof IState) {
            IState state = (IState)target;
            switch (state.getCurrentStateId()) {
                case 8: {
                    Object info = state.getCurrentStateInfo();
                    String label = String.valueOf(target.getName()) + " (Exited";
                    if (info != null && info instanceof ICDIExitInfo) {
                        label = String.valueOf(label) + ". Exit code = " + ((ICDIExitInfo)info).getCode();
                    }
                    return String.valueOf(label) + ")";
                }
            }
        }
        return target.getName();
    }

    protected String getThreadText(IThread thread, boolean qualified) throws DebugException {
        if (thread.isTerminated()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Terminated)", thread.getName());
        }
        if (thread.isStepping()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Stepping)", thread.getName());
        }
        if (!thread.isSuspended()) {
            return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Running)", thread.getName());
        }
        return CDTDebugModelPresentation.getFormattedString("Thread [{0}] (Suspended)", thread.getName());
    }

    protected String getStackFrameText(IStackFrame stackFrame, boolean qualified) throws DebugException {
        IStackFrameInfo info;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IStackFrameInfo)stackFrame.getAdapter((Class)clazz)) != null) {
            Path path;
            String label = new String();
            label = String.valueOf(label) + info.getLevel() + " ";
            if (info.getFunction() != null) {
                label = String.valueOf(label) + info.getFunction() + "() ";
            }
            if (info.getFile() != null && !(path = new Path(info.getFile())).isEmpty()) {
                label = String.valueOf(label) + "at " + (qualified ? path.toOSString() : path.lastSegment()) + ":";
            }
            if (info.getFrameLineNumber() != 0) {
                label = String.valueOf(label) + info.getFrameLineNumber();
            }
            return label;
        }
        return stackFrame.getName();
    }

    protected String getVariableText(IVariable var) throws DebugException {
        String label = new String();
        if (var != null) {
            label = String.valueOf(label) + var.getName();
            IValue value = var.getValue();
            label = String.valueOf(label) + "= " + value.getValueString();
        }
        return label;
    }

    public static String getFormattedString(String key, String arg) {
        return CDTDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format(string, args);
    }
}

