/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractListenerActionDelegate
extends AbstractDebugActionDelegate
implements IDebugEventSetListener,
IPartListener,
IPageListener {
    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.getWindow().removePageListener((IPageListener)this);
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.getPage() == null || this.getAction() == null) {
            return;
        }
        Shell shell = this.getWindow().getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = AbstractListenerActionDelegate.this.getWindow().getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                int i = 0;
                while (i < events.length) {
                    if (events[i].getSource() != null) {
                        AbstractListenerActionDelegate.this.doHandleDebugEvent(events[i]);
                    }
                    ++i;
                }
            }
        };
        this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(r);
    }

    protected IWorkbenchPage getPage() {
        if (this.getWindow() != null) {
            return this.getWindow().getActivePage();
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 1: {
                if (event.isEvaluation() && (event.getDetail() & 0x80) != 0) break;
                this.update(this.getAction(), (ISelection)this.getSelection());
                break;
            }
            case 2: {
                this.update(this.getAction(), (ISelection)this.getSelection());
            }
        }
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        window.addPageListener((IPageListener)this);
    }

    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.setWindow(view.getViewSite().getWorkbenchWindow());
        this.getPage().addPartListener((IPartListener)this);
        this.getPage().getWorkbenchWindow().addPageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getAction() != null && this.getView() != null && this.getPage() != null && this.getPage().equals(page)) {
            Runnable r = new Runnable(){

                public void run() {
                    IWorkbenchWindow window;
                    if (AbstractListenerActionDelegate.this.getPage() != null && (window = AbstractListenerActionDelegate.this.getPage().getWorkbenchWindow()) != null && window.getShell() != null && !window.getShell().isDisposed()) {
                        ISelection selection = AbstractListenerActionDelegate.this.getPage().getSelection("org.eclipse.debug.ui.DebugView");
                        AbstractListenerActionDelegate.this.update(AbstractListenerActionDelegate.this.getAction(), selection);
                    }
                }
            };
            this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(r);
        }
    }

    public void pageClosed(IWorkbenchPage page) {
        if (page.equals(this.getPage())) {
            this.dispose();
        }
    }

    public void pageOpened(IWorkbenchPage page) {
    }
}

