/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryRetrieval;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryText;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemoryControlArea
extends Composite {
    private MemoryPresentation fPresentation;
    private int fIndex = 0;
    private IFormattedMemoryRetrieval fInput = null;
    private IFormattedMemoryBlock fMemoryBlock = null;
    private Text fAddressText;
    private MemoryText fMemoryText;

    public MemoryControlArea(Composite parent, int style, int index) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gridData = new GridData(1808);
        this.setLayout((Layout)layout);
        this.setLayoutData(gridData);
        this.fIndex = index;
        this.fPresentation = this.createPresentation();
        this.fAddressText = this.createAddressText(this);
        this.fMemoryText = this.createMemoryText(this, style, this.fPresentation);
    }

    private MemoryPresentation createPresentation() {
        IPreferenceStore pstore = CDebugUIPlugin.getDefault().getPreferenceStore();
        char[] paddingCharStr = pstore.getString("Memory.PaddingChar").toCharArray();
        int n = paddingCharStr.length > 0 ? paddingCharStr[0] : 46;
        return new MemoryPresentation();
    }

    public MemoryPresentation getPresentation() {
        return this.fPresentation;
    }

    private Text createAddressText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 131072);
        label.setText("Address: ");
        label.pack();
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && e.stateMask == 0) {
                    MemoryControlArea.this.handleAddressEnter();
                }
            }
        });
        return text;
    }

    private MemoryText createMemoryText(Composite parent, int styles, MemoryPresentation presentation) {
        return new MemoryText(parent, 35584, presentation);
    }

    private void handleAddressEnter() {
        this.fAddressText.getText().trim();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Memory.background.RGB")) {
            this.fMemoryText.setBackgroundColor();
        } else if (event.getProperty().equals("Memory.Foreground.RGB")) {
            this.fMemoryText.setForegroundColor();
        } else if (event.getProperty().equals("Memory.font")) {
            this.fMemoryText.changeFont();
        } else if (event.getProperty().equals("Memory.Address.RGB")) {
            this.fMemoryText.setAddressColor();
        } else if (event.getProperty().equals("Memory.Changed.RGB")) {
            this.fMemoryText.setChangedColor();
        } else if (event.getProperty().equals("Memory.Dirty.RGB")) {
            this.fMemoryText.setDirtyColor();
        }
    }

    public void setInput(IFormattedMemoryRetrieval input) {
        this.fInput = input;
        this.fMemoryBlock = CDebugUIPlugin.getDefault().getBlock(this.fInput, this.fIndex);
        this.fPresentation.setMemoryBlock(this.fMemoryBlock);
        this.refresh();
    }

    private void refresh() {
        this.fAddressText.setText(this.fPresentation.getStartAddress());
        this.fMemoryText.refresh();
    }
}

