/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.util.LinkedList;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryPresentation;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MemoryText {
    private StyledText fText = null;
    private MemoryPresentation fPresentation = null;

    public MemoryText(Composite parent, int style, MemoryPresentation presentation) {
        this.fText = new StyledText(parent, style);
        this.fText.setLayoutData((Object)new GridData(1808));
        this.fPresentation = presentation;
        this.initialize();
    }

    private void initialize() {
        this.fText.invokeAction(0x1000009);
        this.fText.setKeyBinding(0x1000009, 0);
        this.fText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                MemoryText.this.handleExtendedModify(e);
            }
        });
        this.fText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                MemoryText.this.handleVerifyKey(e);
            }
        });
        this.refresh();
    }

    private void handleExtendedModify(ExtendedModifyEvent event) {
        if (event.length != 1) {
            return;
        }
        int offset = this.fText.getCaretOffset() - 1;
        int size = this.fPresentation.getItemSize(offset);
        this.fPresentation.setItem(offset, this.fText.getText().substring(offset, offset + size));
        Point[] zones = this.fPresentation.getDirtyZones();
        this.refresh(zones, this.fPresentation.getText(zones));
    }

    public void refresh() {
        this.fText.setFont(new Font((Device)this.fText.getDisplay(), this.getFontData()));
        this.fText.setBackground(this.getBackgroundColor());
        this.fText.setForeground(this.getForegroundColor());
        this.fText.setText(this.fPresentation.getText());
        LinkedList<StyleRange> list = new LinkedList<StyleRange>();
        Point[] zones = this.fPresentation.getChangedZones();
        int i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getChangedColor(), this.getBackgroundColor()));
            ++i;
        }
        zones = this.fPresentation.getAddressZones();
        i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getAddressColor(), this.getBackgroundColor()));
            ++i;
        }
        zones = this.fPresentation.getDirtyZones();
        i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getDirtyColor(), this.getBackgroundColor()));
            ++i;
        }
        this.fText.setStyleRanges(list.toArray(new StyleRange[list.size()]));
        this.fText.redraw();
    }

    private void refresh(Point[] zones, String[] items) {
        int count = zones.length < items.length ? zones.length : items.length;
        int i = 0;
        while (i < count) {
            this.fText.replaceTextRange(zones[i].x, zones[i].y - zones[i].x + 1, items[i]);
            this.fText.setStyleRange(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getDirtyColor(), this.getBackgroundColor()));
            this.fText.redrawRange(zones[i].x, zones[i].y - zones[i].x + 1, false);
            ++i;
        }
    }

    private void handleVerifyKey(VerifyEvent event) {
        if (event.character == '\n' || event.character == '\r' || event.character == '\b' || event.character == '\u007f' || !this.fPresentation.isAcceptable(event.character, this.fText.getCaretOffset())) {
            event.doit = false;
        }
    }

    private FontData getFontData() {
        IPreferenceStore pstore = CDebugUIPlugin.getDefault().getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)pstore, (String)"Memory.font");
        return fontData;
    }

    private Color getForegroundColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Foreground.RGB");
    }

    private Color getBackgroundColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.background.RGB");
    }

    private Color getAddressColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Address.RGB");
    }

    private Color getChangedColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Changed.RGB");
    }

    private Color getDirtyColor() {
        return CDebugUIPlugin.getPreferenceColor("Memory.Dirty.RGB");
    }

    public void changeFont() {
        Font oldFont = this.fText.getFont();
        this.fText.setFont(new Font((Device)this.fText.getDisplay(), this.getFontData()));
        oldFont.dispose();
    }

    public void setForegroundColor() {
        this.fText.setForeground(CDebugUIPlugin.getPreferenceColor("Memory.Foreground.RGB"));
    }

    public void setBackgroundColor() {
        this.fText.setBackground(CDebugUIPlugin.getPreferenceColor("Memory.background.RGB"));
    }

    public void setChangedColor() {
        LinkedList<StyleRange> list = new LinkedList<StyleRange>();
        Point[] zones = this.fPresentation.getChangedZones();
        int i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getChangedColor(), this.getBackgroundColor()));
            ++i;
        }
        this.fText.setStyleRanges(list.toArray(new StyleRange[list.size()]));
    }

    public void setAddressColor() {
        LinkedList<StyleRange> list = new LinkedList<StyleRange>();
        Point[] zones = this.fPresentation.getAddressZones();
        int i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getAddressColor(), this.getBackgroundColor()));
            ++i;
        }
        this.fText.setStyleRanges(list.toArray(new StyleRange[list.size()]));
    }

    public void setDirtyColor() {
        LinkedList<StyleRange> list = new LinkedList<StyleRange>();
        Point[] zones = this.fPresentation.getDirtyZones();
        int i = 0;
        while (i < zones.length) {
            list.add(new StyleRange(zones[i].x, zones[i].y - zones[i].x + 1, this.getDirtyColor(), this.getBackgroundColor()));
            ++i;
        }
        this.fText.setStyleRanges(list.toArray(new StyleRange[list.size()]));
    }
}

