/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryRetrieval;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.internal.ui.preferences.MemoryViewPreferencePage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CDebugUIPlugin
extends AbstractUIPlugin {
    private static CDebugUIPlugin plugin;
    private ResourceBundle resourceBundle;
    protected Map fDebuggerPageMap;

    public CDebugUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.ui.CDebugUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CDebugUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.debug.ui";
        }
        return CDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    protected void initializeDefaultPreferences(IPreferenceStore pstore) {
        MemoryViewPreferencePage.initDefaults(pstore);
    }

    public static CDTDebugModelPresentation getDebugModelPresentation() {
        return CDTDebugModelPresentation.getDefault();
    }

    public void addBlock(IFormattedMemoryRetrieval mbr, IFormattedMemoryBlock memoryBlock) {
    }

    public void removeBlock(IFormattedMemoryRetrieval mbr, IFormattedMemoryBlock memoryBlock) {
    }

    public void removeAllBlocks(IFormattedMemoryRetrieval mbr) {
    }

    public IFormattedMemoryBlock getBlock(IFormattedMemoryRetrieval mbr, int index) {
        return null;
    }

    public IFormattedMemoryBlock[] getBlocks(IFormattedMemoryRetrieval mbr) {
        return new IFormattedMemoryBlock[0];
    }

    public static void log(IStatus status) {
        CDebugUIPlugin.getDefault().getLog().log(status);
    }

    public ILaunchConfigurationTab getDebuggerPage(String debuggerID) {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fDebuggerPageMap.get(debuggerID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 100, "An error occurred retrieving a C Debugger page", (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IPluginDescriptor descriptor = CDebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CDebuggerPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("debuggerID");
            this.fDebuggerPageMap.put(id, infos[i]);
            ++i;
        }
    }
}

