/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.internal.core.CDebugElement;
import org.eclipse.cdt.debug.internal.core.CDebugTarget;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess process, final IProject project, final boolean allowTerminate, final boolean allowDisconnect, boolean stopInMain) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, cdiTarget, name, process, project, allowTerminate, allowDisconnect);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
        if (stopInMain) {
            ICDILocation location = cdiTarget.getSession().getSourceManager().createLocation("", "main", 0);
            try {
                cdiTarget.getSession().getBreakpointManager().setLocationBreakpoint(0, location, null, null);
            }
            catch (CDIException e) {
                ((CDebugElement)target[0]).targetRequestFailed(MessageFormat.format("{0} occurred setting temporary breakpoint.", e.toString()), e);
            }
        }
        target[0].resume();
        return target[0];
    }
}

