/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICSourceLocator;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryRetrieval;
import org.eclipse.cdt.debug.core.IRestart;
import org.eclipse.cdt.debug.core.IState;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.ICDIDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDILoadedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.internal.core.CDebugElement;
import org.eclipse.cdt.debug.internal.core.CSourceLocator;
import org.eclipse.cdt.debug.internal.core.CThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;

public class CDebugTarget
extends CDebugElement
implements IDebugTarget,
ICDIEventListener,
IRestart,
IFormattedMemoryRetrieval,
IState,
ILaunchListener {
    private ArrayList fThreads;
    private IProcess fProcess;
    private ICDITarget fCDITarget;
    private String fName;
    private boolean fSuspended = true;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fDisconnected;
    private boolean fResumeOnStartup = false;
    private ILaunch fLaunch;
    private ICDIDebugConfiguration fConfig;
    private boolean fSupportsTerminate;
    private boolean fSupportsDisconnect;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private int fSuspendCount = 0;
    private ICSourceLocator fSourceLocator = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CDebugTarget(ILaunch launch, ICDITarget cdiTarget, String name, IProcess process, IProject project, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.setLaunch(launch);
        this.setDebugTarget(this);
        this.setName(name);
        this.setProcess(process);
        this.setCDITarget(cdiTarget);
        this.fConfig = cdiTarget.getSession().getConfiguration();
        this.fSupportsTerminate = allowsTerminate & this.fConfig.supportsTerminate();
        this.fSupportsDisconnect = allowsDisconnect & this.fConfig.supportsDisconnect();
        this.fSourceLocator = this.createSourceLocator(project);
        launch.setSourceLocator((ISourceLocator)this.fSourceLocator);
        this.setThreadList(new ArrayList(5));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeState();
        this.initializeBreakpoints();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    protected void initializeState() {
        ICDIThread[] threads = new ICDIThread[]{};
        try {
            threads = this.getCDITarget().getThreads();
        }
        catch (CDIException e) {
            this.internalError(e);
        }
        int i = 0;
        while (i < threads.length) {
            this.createRunningThread(threads[i]);
            ++i;
        }
        if (this.isResumeOnStartup()) {
            this.setSuspended(false);
        }
    }

    protected void initializeBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] bps = manager.getBreakpoints(CDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < bps.length) {
            ++i;
        }
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    protected void setProcess(IProcess process) {
        this.fProcess = process;
    }

    public IThread[] getThreads() {
        ArrayList threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        try {
            this.setTerminating(true);
            this.getCDISession().terminate();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occurred while terminating.", e.toString()), e);
        }
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public boolean canResume() {
        return this.isSuspended() && this.isAvailable();
    }

    public boolean canSuspend() {
        if (!this.isSuspended() && this.isAvailable()) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        try {
            this.getCDITarget().resume();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occurred resuming target.", e.toString()), e);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            this.getCDITarget().suspend();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occurred suspending target.", e.toString()), e);
        }
    }

    protected void suspendThreads() {
    }

    protected synchronized List refreshThreads() {
        ArrayList<CThread> list = new ArrayList<CThread>(5);
        ArrayList<CThread> newThreads = new ArrayList<CThread>(5);
        try {
            ICDIThread[] cdiThreads = this.getCDITarget().getThreads();
            int i = 0;
            while (i < cdiThreads.length) {
                CThread thread = this.findThread(cdiThreads[i]);
                if (thread == null) {
                    thread = new CThread(this, cdiThreads[i]);
                    newThreads.add(thread);
                } else {
                    ((AbstractCollection)this.getThreadList()).remove(thread);
                }
                list.add(thread);
                ++i;
            }
            Iterator it = ((AbstractList)this.getThreadList()).iterator();
            while (it.hasNext()) {
                ((CThread)it.next()).terminated();
            }
            this.getThreadList().clear();
            this.setThreadList(list);
            it = ((AbstractList)newThreads).iterator();
            while (it.hasNext()) {
                ((CThread)it.next()).fireCreationEvent();
            }
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        return newThreads;
    }

    protected void resumeThreads(ICDIResumedEvent event) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    protected boolean supportsDisconnect() {
        return this.fConfig.supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.fConfig.supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported("Session does not support 'disconnect'");
        }
        try {
            this.getCDITarget().disconnect();
            this.disconnected();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} ocurred disconnecting from target.", e.toString()), e);
        }
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    protected void setDisconnected(boolean disconnected) {
        this.fDisconnected = disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    private void setCDITarget(ICDITarget cdiTarget) {
        this.fCDITarget = cdiTarget;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this.fCDITarget;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.IState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null && event instanceof ICDIDestroyedEvent) {
            this.handleTerminatedEvent((ICDIDestroyedEvent)event);
        } else if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDICreatedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleThreadCreatedEvent((ICDICreatedEvent)event);
                }
            } else if (event instanceof ICDISuspendedEvent) {
                if (source instanceof ICDITarget || source instanceof ICDIThread) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)event);
                }
            } else if (event instanceof ICDIResumedEvent || source instanceof ICDIThread) {
                if (source instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            } else if (event instanceof ICDIExitedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleExitedEvent((ICDIExitedEvent)event);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleThreadTerminatedEvent((ICDIDestroyedEvent)event);
                }
            } else if (event instanceof ICDIDisconnectedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                }
            } else if (event instanceof ICDIChangedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleChangedEvent((ICDIChangedEvent)event);
                }
            } else if (event instanceof ICDILoadedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleLoadedEvent((ICDILoadedEvent)event);
                }
            } else if (event instanceof ICDIRestartedEvent && source instanceof ICDITarget) {
                this.handleRestartedEvent((ICDIRestartedEvent)event);
            }
        }
    }

    public boolean canRestart() {
        return this.fConfig.supportsRestart() && this.isSuspended() && this.isAvailable();
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        try {
            this.getCDITarget().restart();
            this.restarted();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} ocurred restarting the target.", e.toString()), e);
        }
    }

    protected void restarted() {
    }

    public IFormattedMemoryBlock getFormattedMemoryBlock(long startAddress, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        return null;
    }

    public IFormattedMemoryBlock getFormattedMemoryBlock(long startAddress, int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        return null;
    }

    public int[] getSupportedFormats() throws DebugException {
        return null;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected();
    }

    private void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean terminating) {
        this.fTerminating = terminating;
    }

    protected void terminated() {
        this.setTerminating(false);
        if (!this.isTerminated()) {
            this.setTerminated(true);
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.removeAllBreakpoints();
    }

    protected void removeAllThreads() {
        Iterator itr = ((AbstractList)this.getThreadList()).iterator();
        this.setThreadList(new ArrayList(0));
        while (itr.hasNext()) {
            CThread thread = (CThread)itr.next();
            thread.terminated();
        }
    }

    protected void removeAllBreakpoints() {
    }

    protected CThread createThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        this.getThreadList().add(thread);
        thread.fireCreationEvent();
        return thread;
    }

    protected CThread createRunningThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        thread.setRunning(true);
        this.getThreadList().add(thread);
        thread.fireCreationEvent();
        return thread;
    }

    private void setResumeOnStartup(boolean resume) {
        this.fResumeOnStartup = resume;
    }

    protected boolean isResumeOnStartup() {
        return this.fResumeOnStartup;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        CThread thread;
        this.setSuspended(true);
        this.setCurrentStateId(7);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        List newThreads = this.refreshThreads();
        if (event.getSource() instanceof ICDIThread && (thread = this.findThread((ICDIThread)event.getSource())) != null && newThreads.contains(thread)) {
            thread.handleDebugEvent(event);
        }
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpoint) {
            this.handleBreakpointHit((ICDIBreakpoint)reason);
        } else if (reason instanceof ICDISignal) {
            this.handleSuspendedBySignal((ICDISignal)reason);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setSuspended(false);
        this.setCurrentStateId(5);
        this.setCurrentStateInfo(null);
        this.resumeThreads(event);
        this.fireResumeEvent(0);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpoint breakpoint) {
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignal signal) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(ICDIExitedEvent event) {
        this.removeAllThreads();
        this.setCurrentStateId(8);
        this.setCurrentStateInfo(event.getExitInfo());
        this.fireChangeEvent(512);
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.setCurrentStateId(10);
        this.setCurrentStateInfo(null);
        IProcess process = this.getProcess();
        if (process != null) {
            try {
                process.terminate();
            }
            catch (DebugException e) {
                CDebugCorePlugin.log(e.getStatus());
            }
        }
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setCurrentStateId(9);
        this.setCurrentStateInfo(null);
        IProcess process = this.getProcess();
        if (process != null) {
            try {
                process.terminate();
            }
            catch (DebugException e) {
                CDebugCorePlugin.log(e.getStatus());
            }
        }
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    private void handleLoadedEvent(ICDILoadedEvent event) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent event) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread == null) {
            this.createThread(cdiThread);
        } else {
            thread.disposeStackFrames();
            thread.fireChangeEvent(512);
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread != null) {
            ((AbstractCollection)this.getThreadList()).remove(thread);
            thread.terminated();
        }
    }

    public CThread findThread(ICDIThread cdiThread) {
        ArrayList threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int id) {
        this.fCurrentStateId = id;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object info) {
        this.fCurrentStateInfo = info;
    }

    protected int getSuspendCount() {
        return this.fSuspendCount;
    }

    protected void incrementSuspendCount() {
        ++this.fSuspendCount;
    }

    public void fireSuspendEvent(int detail) {
        this.incrementSuspendCount();
        super.fireSuspendEvent(detail);
    }

    private ICSourceLocator createSourceLocator(IProject project) {
        return new CSourceLocator(this, project);
    }

    protected ICSourceLocator getSourceLocator() {
        return this.fSourceLocator;
    }
}

