/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.internal.core.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.CStackFrame;
import org.eclipse.cdt.debug.internal.core.CValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CLocalVariable
extends CModificationVariable
implements ICDIEventListener {
    private ICDIVariable fCDIVariable;
    private CStackFrame fStackFrame;

    public CLocalVariable(CStackFrame stackFrame, ICDIVariable cdiVariable) {
        super((CDebugTarget)stackFrame.getDebugTarget());
        this.fStackFrame = stackFrame;
        this.fCDIVariable = cdiVariable;
    }

    protected void setValue(ICDIValue value) throws DebugException {
        try {
            this.getCDIVariable().setValue(value);
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occured modifying local variable value.", e.toString()), e);
        }
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return this.getStackFrame().isSuspended() ? this.getCDIVariable().getValue() : this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        String name = null;
        try {
            name = this.getCDIVariable().getName();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occured while retrieving local variable name.", e.toString()), e);
        }
        return name;
    }

    public String getReferenceTypeName() throws DebugException {
        String type = null;
        try {
            type = this.getCDIVariable().getTypeName();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occured while retrieving local variable type.", e.toString()), e);
        }
        return type;
    }

    protected ICDIVariable getCDIVariable() {
        return this.fCDIVariable;
    }

    protected void setCDIVariable(ICDIVariable newVar) {
        this.fCDIVariable = newVar;
    }

    protected CStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget()) && event instanceof ICDIChangedEvent && source instanceof ICDIVariable && source.equals(this.getCDIVariable())) {
            this.handleChangedEvent((ICDIChangedEvent)event);
        }
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
        try {
            if (!this.getValue().hasVariables()) {
                this.setChanged(true);
                this.getStackFrame().fireChangeEvent(512);
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    public void setValue(IValue value) throws DebugException {
        if (this.verifyValue(value)) {
            this.setValue(((CValue)value).getUnderlyingValue());
        }
    }
}

