/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStringValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStructureValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.internal.core.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public abstract class CModificationVariable
extends CVariable {
    private static final String ERROR_MESSAGE = "Value modification failed - unable to generate value from expression: {0}";

    public CModificationVariable(CDebugTarget target) {
        super(target);
    }

    public boolean supportsValueModification() {
        try {
            ICDIValue currentValue = this.getCurrentValue();
            if (currentValue != null) {
                return !(currentValue instanceof ICDIArrayValue) && !(currentValue instanceof ICDIStructureValue) && !(currentValue instanceof ICDIStringValue);
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean verifyValue(String expression) {
        try {
            ICDIValue vmValue = this.generateValue(expression);
            return vmValue != null;
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    protected ICDIValue generateValue(String expression) throws DebugException {
        ICDIValue value = null;
        try {
            value = this.getCDITarget().evaluateExpressionToValue(expression);
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(MessageFormat.format(ERROR_MESSAGE, expression), null);
        }
        return value;
    }

    public boolean verifyValue(IValue value) {
        return value.getDebugTarget().equals(this.getDebugTarget());
    }

    public final void setValue(String expression) throws DebugException {
        ICDIValue value = this.generateValue(expression);
        if (value == null) {
            this.targetRequestFailed(MessageFormat.format(ERROR_MESSAGE, expression), null);
        }
        this.setValue(value);
        this.fireChangeEvent(512);
    }

    protected abstract void setValue(ICDIValue var1) throws DebugException;
}

