/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICSourceLocator;
import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.CDebugTarget;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceLocator
implements ICSourceLocator {
    private IProject fProject;
    private CDebugTarget fTarget;
    private int fMode = 0;
    private int fInternalMode = 0;
    static /* synthetic */ Class class$0;

    public CSourceLocator(CDebugTarget target, IProject project) {
        this.fProject = project;
        this.fTarget = target;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object result = null;
        if (stackFrame != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (stackFrame.getAdapter((Class)clazz) != null) {
                try {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.IStackFrameInfo");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = this.getInput((IStackFrameInfo)stackFrame.getAdapter((Class)clazz2));
                }
                catch (DebugException e) {
                    CDebugCorePlugin.log(e);
                }
            }
        }
        return result;
    }

    public int getLineNumber(IStackFrameInfo frameInfo) {
        int result = 0;
        if (this.getMode() == 0) {
            result = frameInfo.getFrameLineNumber();
        }
        return result;
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int mode) {
    }

    protected void setInternalMode(int mode) {
        this.fInternalMode = mode;
    }

    protected Object getInput(IStackFrameInfo frameInfo) throws DebugException {
        Object result = null;
        switch (this.getMode()) {
            case 0: {
                result = this.getSourceInput(frameInfo);
            }
        }
        return result;
    }

    private Object getSourceInput(IStackFrameInfo info) {
        Object result = null;
        if (info != null && this.fProject != null) {
            this.setInternalMode(0);
            String fileName = info.getFile();
            if (fileName != null && fileName.length() > 0) {
                result = this.findFile(this.fProject, fileName);
            }
        }
        return result;
    }

    private Object findFile(IProject project, String fileName) {
        String pPath;
        Path path = new Path(fileName);
        int i = (fileName = path.toOSString()).indexOf(pPath = new String(project.getLocation().toOSString()));
        if (i >= 0 && fileName.length() > (i += pPath.length() + 1)) {
            return project.getFile(fileName.substring(i));
        }
        IFile f = null;
        try {
            f = this.findFile((IContainer)project, (IPath)path);
            if (f != null) {
                return f;
            }
            if (f == null) {
                IProject[] p = project.getReferencedProjects();
                int j = 0;
                while (j < p.length) {
                    f = this.findFile((IContainer)p[j], (IPath)new Path(fileName));
                    if (f != null) {
                        return f;
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {}
        if (f != null) {
            return f;
        }
        return null;
    }

    private IFile findFile(IContainer parent, IPath name) throws CoreException {
        IResource found;
        if (name.isAbsolute() && name.toOSString().startsWith(parent.getLocation().toOSString())) {
            name = new Path(name.toOSString().substring(parent.getLocation().toOSString().length() + 1));
        }
        if ((found = parent.findMember(name)) != null && found.getType() == 1) {
            return (IFile)found;
        }
        IResource[] children = parent.members();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IContainer) {
                return this.findFile((IContainer)children[i], name);
            }
            ++i;
        }
        return null;
    }
}

