/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.internal.core.CDebugElement;
import org.eclipse.cdt.debug.internal.core.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.CValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class CVariable
extends CDebugElement
implements IVariable,
ICDIEventListener {
    private CValue fValue;
    private int fLastChangeIndex = -1;
    private boolean fChanged = false;
    static /* synthetic */ Class class$0;

    public CVariable(CDebugTarget target) {
        super(target);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IValue getValue() throws DebugException {
        ICDIValue currentValue = this.getCurrentValue();
        if (this.fValue == null) {
            this.fValue = CValue.createValue((CDebugTarget)this.getDebugTarget(), currentValue);
        }
        return this.fValue;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.getValue().hasVariables() ? false : this.fChanged;
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public void setValue(IValue value) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    protected abstract ICDIValue retrieveValue() throws DebugException, CDIException;

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected final ICDIValue getCurrentValue() throws DebugException {
        try {
            return this.retrieveValue();
        }
        catch (CDIException e) {
            this.targetRequestFailed(MessageFormat.format("{0} occurred retrieving value.", e.toString()), e);
            return null;
        }
    }

    protected void setChangeCount(int count) {
        this.fLastChangeIndex = count;
    }

    protected int getChangeCount() {
        return this.fLastChangeIndex;
    }

    protected ICDIValue getLastKnownValue() {
        if (this.fValue == null) {
            return null;
        }
        return this.fValue.getUnderlyingValue();
    }

    protected void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    protected synchronized void setChanged(boolean changed) throws DebugException {
        if (this.getValue().hasVariables()) {
            IVariable[] vars = this.getValue().getVariables();
            int i = 0;
            while (i < vars.length) {
                ((CVariable)vars[i]).setChanged(changed);
                ++i;
            }
        } else {
            this.fChanged = changed;
        }
    }

    public abstract void handleDebugEvent(ICDIEvent var1);

    public abstract String getName() throws DebugException;

    public abstract String getReferenceTypeName() throws DebugException;
}

