/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecAbort;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowExitCode;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowExitCodeInfo;

public class MIInferior
extends Process {
    static final int SUSPENDED = 1;
    static final int RUNNING = 2;
    static final int TERMINATED = 4;
    boolean connected = false;
    int state = 0;
    MISession session;
    OutputStream out;
    PipedInputStream in;
    PipedOutputStream inPiped;
    PipedInputStream err;
    PipedOutputStream errPiped;

    MIInferior(MISession mi) {
        this.session = mi;
    }

    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    this.buf.append(b);
                    if (b == 10) {
                        this.flush();
                    }
                }

                public void flush() throws IOException {
                    CLICommand cmd = new CLICommand(this.buf.toString()){

                        public void setToken(int token) {
                        }
                    };
                    try {
                        MIInferior.this.session.postCommand(cmd);
                    }
                    catch (MIException mIException) {
                        throw new IOException("no mi session");
                    }
                }
            };
        }
        return this.out;
    }

    public InputStream getInputStream() {
        if (this.in == null) {
            try {
                this.inPiped = new PipedOutputStream();
                this.in = new PipedInputStream(this.inPiped);
            }
            catch (IOException iOException) {}
        }
        return this.in;
    }

    public InputStream getErrorStream() {
        if (this.err == null) {
            try {
                this.errPiped = new PipedOutputStream();
                this.err = new PipedInputStream(this.errPiped);
            }
            catch (IOException iOException) {}
        }
        return this.err;
    }

    public int waitFor() throws InterruptedException {
        if (!this.isTerminated()) {
            MIInferior mIInferior = this;
            synchronized (mIInferior) {
                this.wait();
            }
        }
        return this.exitValue();
    }

    public int exitValue() {
        if (this.isTerminated()) {
            if (!this.session.isTerminated()) {
                CommandFactory factory = this.session.getCommandFactory();
                MIGDBShowExitCode code = factory.createMIGDBShowExitCode();
                try {
                    this.session.postCommand(code);
                    MIGDBShowExitCodeInfo info = code.getMIGDBShowExitCodeInfo();
                    return info.getCode();
                }
                catch (MIException mIException) {}
            }
            return 0;
        }
        throw new IllegalThreadStateException();
    }

    public void destroy() {
        if (!this.isTerminated()) {
            CommandFactory factory = this.session.getCommandFactory();
            MIExecAbort abort = factory.createMIExecAbort();
            try {
                this.session.postCommand(abort);
                abort.getMIInfo();
            }
            catch (MIException mIException) {}
            this.setTerminated();
        }
    }

    public synchronized boolean isSuspended() {
        return this.state == 1;
    }

    public synchronized boolean isRunning() {
        return this.state == 2;
    }

    public synchronized boolean isTerminated() {
        return this.state == 4;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void setConnected() {
        this.connected = true;
    }

    public synchronized void setDisConnected() {
        this.connected = false;
    }

    public synchronized void setSuspended() {
        this.state = 1;
    }

    public synchronized void setRunning() {
        this.state = 2;
    }

    public synchronized void setTerminated() {
        this.state = 4;
        try {
            if (this.inPiped != null) {
                this.inPiped.close();
                this.inPiped = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.errPiped != null) {
                this.errPiped.close();
                this.errPiped = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.session.fireEvent(new MIInferiorExitEvent());
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.inPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.errPiped;
    }
}

