/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.output.MIBreakPoint;

public class Breakpoint
extends SessionObject
implements ICDILocationBreakpoint {
    ICDILocation location;
    ICDICondition condition;
    MIBreakPoint miBreakPoint;
    BreakpointManager mgr;

    public Breakpoint(BreakpointManager m, MIBreakPoint miBreak) {
        super(m.getCSession());
        this.miBreakPoint = miBreak;
        this.mgr = m;
    }

    MIBreakPoint getMIBreakPoint() {
        return this.miBreakPoint;
    }

    public ICDICondition getCondition() throws CDIException {
        if (this.condition == null) {
            this.condition = new Condition(this.miBreakPoint.getIgnoreCount(), this.miBreakPoint.getWhat());
        }
        return this.condition;
    }

    public String getThreadId() throws CDIException {
        return this.miBreakPoint.getThreadId();
    }

    public boolean isEnabled() throws CDIException {
        return this.miBreakPoint.isEnabled();
    }

    public boolean isHardware() {
        return this.miBreakPoint.isHardware();
    }

    public boolean isTemporary() {
        return this.miBreakPoint.isTemporary();
    }

    public void setCondition(ICDICondition condition) throws CDIException {
        this.mgr.setCondition((ICDIBreakpoint)this, condition);
        this.condition = condition;
    }

    public void setEnabled(boolean enable) throws CDIException {
        if (!enable && this.isEnabled()) {
            this.mgr.disableBreakpoint((ICDIBreakpoint)this);
        } else if (enable && !this.isEnabled()) {
            this.mgr.enableBreakpoint((ICDIBreakpoint)this);
        }
    }

    public ICDILocation getLocation() throws CDIException {
        if (this.location == null) {
            this.location = new Location(this.miBreakPoint.getFile(), this.miBreakPoint.getFunction(), this.miBreakPoint.getLine(), this.miBreakPoint.getAddress());
        }
        return this.location;
    }
}

