/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.DebugConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;

public class CSession
implements ICDISession,
ICDISessionObject {
    Properties props;
    MISession session;
    BreakpointManager breakpointManager;
    EventManager eventManager;
    ExpressionManager expressionManager;
    VariableManager variableManager;
    MemoryManager memoryManager;
    SignalManager signalManager;
    SourceManager sourceManager;
    CTarget ctarget;

    public CSession(MISession s) {
        this.session = s;
        this.props = new Properties();
        this.breakpointManager = new BreakpointManager(this);
        this.eventManager = new EventManager(this);
        s.addObserver(this.eventManager);
        this.expressionManager = new ExpressionManager(this);
        this.variableManager = new VariableManager(this);
        this.memoryManager = new MemoryManager(this);
        this.signalManager = new SignalManager(this);
        this.sourceManager = new SourceManager(this);
        this.ctarget = new CTarget(this);
    }

    MISession getMISession() {
        return this.session;
    }

    CTarget getCTarget() {
        return this.ctarget;
    }

    public String getAttribute(String key) {
        return this.props.getProperty(key);
    }

    public ICDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ICDIEventManager getEventManager() {
        return this.eventManager;
    }

    public ICDIExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public ICDIMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ICDISignalManager getSignalManager() {
        return this.signalManager;
    }

    public ICDISourceManager getSourceManager() {
        return this.sourceManager;
    }

    public ICDITarget[] getTargets() {
        return new ICDITarget[]{this.ctarget};
    }

    public ICDITarget getCurrentTarget() {
        return this.ctarget;
    }

    public void setCurrentTarget(ICDITarget target) throws CDIException {
        if (target instanceof CTarget) {
            this.ctarget = (CTarget)target;
            return;
        }
        throw new CDIException("Unkown target");
    }

    public void setAttribute(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void terminate() throws CDIException {
        this.session.terminate();
    }

    public ICDIDebugConfiguration getConfiguration() {
        return new DebugConfiguration();
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return new RuntimeOptions();
    }

    public ICDISession getSession() {
        return this;
    }
}

