/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecInterrupt;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadListIds;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadListIdsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class CTarget
implements ICDITarget {
    CSession session;
    CThread[] noThreads = new CThread[0];
    CThread[] currentThreads;
    int currentThreadId;

    public CTarget(CSession s) {
        this.session = s;
        this.currentThreads = this.noThreads;
    }

    CSession getCSession() {
        return this.session;
    }

    public ICDISession getSession() {
        return this.session;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(CThread cthread) throws CDIException {
        MISession mi;
        this.session.setCurrentTarget(this);
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIThreadSelect select = factory.createMIThreadSelect(id);
            try {
                mi.postCommand(select);
                MIThreadSelectInfo info = select.getMIThreadSelectInfo();
                this.currentThreadId = info.getNewThreadId();
            }
            catch (MIException e) {
                throw new CDIException(e.toString());
            }
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            mi.fireEvent(new MIThreadExitEvent(id));
            throw new CDIException("Thread destroyed");
        }
    }

    void updateState(int newThreadId) {
        CThread[] oldThreads = this.currentThreads;
        CThread[] newThreads = this.getCThreads();
        if (oldThreads != null && oldThreads.length > 0) {
            ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
            int i = 0;
            while (i < oldThreads.length) {
                boolean found = false;
                int j = 0;
                while (j < newThreads.length) {
                    if (newThreads[j].getId() == oldThreads[i].getId()) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    dList.add(new Integer(oldThreads[i].getId()));
                }
                ++i;
            }
            dList.isEmpty();
        }
        this.currentThreads = newThreads;
        this.currentThreadId = newThreadId;
    }

    public CThread[] getCThreads() {
        CThread[] cthreads = this.noThreads;
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIThreadListIds tids = factory.createMIThreadListIds();
        try {
            mi.postCommand(new CLICommand("info threads"));
            mi.postCommand(tids);
            MIThreadListIdsInfo info = tids.getMIThreadListIdsInfo();
            int[] ids = info.getThreadIds();
            if (ids != null && ids.length > 0) {
                cthreads = new CThread[ids.length];
                int i = 0;
                while (i < ids.length) {
                    cthreads[i] = new CThread(this, ids[i]);
                    ++i;
                }
            } else {
                cthreads = new CThread[]{new CThread(this, 0)};
            }
        }
        catch (MIException mIException) {}
        return cthreads;
    }

    public ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads == null) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public void restart() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecRun run = factory.createMIExecRun(new String[0]);
        try {
            mi.postCommand(run);
            MIInfo info = run.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void resume() throws CDIException {
        block7: {
            MISession mi = this.session.getMISession();
            if (mi.getMIInferior().isRunning()) {
                throw new CDIException("Inferior already running");
            }
            if (mi.getMIInferior().isSuspended()) {
                CommandFactory factory = mi.getCommandFactory();
                MIExecContinue cont = factory.createMIExecContinue();
                try {
                    mi.postCommand(cont);
                    MIInfo info = cont.getMIInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    break block7;
                }
                catch (MIException e) {
                    throw new CDIException(e.toString());
                }
            }
            if (mi.getMIInferior().isTerminated()) {
                this.restart();
            } else {
                this.restart();
            }
        }
    }

    public void stepInto() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStep step = factory.createMIExecStep();
        try {
            mi.postCommand(step);
            MIInfo info = step.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void stepIntoInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStepInstruction stepi = factory.createMIExecStepInstruction();
        try {
            mi.postCommand(stepi);
            MIInfo info = stepi.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void stepOver() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNext next = factory.createMIExecNext();
        try {
            mi.postCommand(next);
            MIInfo info = next.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void stepOverInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNextInstruction nexti = factory.createMIExecNextInstruction();
        try {
            mi.postCommand(nexti);
            MIInfo info = nexti.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void stepReturn() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            mi.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void suspend() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecInterrupt interrupt = factory.createMIExecInterrupt();
        try {
            mi.postCommand(interrupt);
            MIInfo info = interrupt.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void disconnect() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MITargetDetach detach = factory.createMITargetDetach();
        try {
            mi.postCommand(detach);
            MIInfo info = detach.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void finish() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            mi.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public String evaluateExpressionToString(String expressionText) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(expressionText);
        try {
            mi.postCommand(evaluate);
            MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getExpression();
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public void terminate() throws CDIException {
        this.session.getMISession().getMIInferior().destroy();
    }

    public boolean isTerminated() {
        return this.session.getMISession().getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.session.getMISession().getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.session.getMISession().getMIInferior().isSuspended();
    }

    public ICDIGlobalVariable[] getGlobalVariables() throws CDIException {
        return new ICDIGlobalVariable[0];
    }

    public ICDIRegisterGroup[] getRegisterGroups() throws CDIException {
        return new ICDIRegisterGroup[0];
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        return new ICDISharedLibrary[0];
    }

    public ICDIMemoryBlock getCMemoryBlock(long startAddress, long length) throws CDIException {
        return null;
    }

    public Process getProcess() {
        return this.session.getMISession().getMIInferior();
    }

    public ICDIValue evaluateExpressionToValue(String expressionText) throws CDIException {
        return null;
    }
}

