/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.StackFrame;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListFramesInfo;

public class CThread
extends CObject
implements ICDIThread {
    int id;
    static StackFrame[] noStack = new StackFrame[0];

    public CThread(CTarget target, int threadId) {
        super(target);
        this.id = threadId;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public void finish() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().finish();
    }

    public ICDIStackFrame[] getStackFrames() throws CDIException {
        ICDIStackFrame[] stack = noStack;
        CSession session = this.getCTarget().getCSession();
        session.getVariableManager();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIStackListFrames frames = factory.createMIStackListFrames();
        try {
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(frames);
            MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIFrame[] miFrames = info.getMIFrames();
            stack = new StackFrame[miFrames.length];
            int i = 0;
            while (i < stack.length) {
                stack[i] = new StackFrame(this, miFrames[i]);
                ++i;
            }
            return stack;
        }
        catch (MIException e) {
            System.out.println(e);
        }
        catch (CDIException e) {
            System.out.println((Object)e);
        }
        return stack;
    }

    public void setCurrentStackFrame(StackFrame stackframe) throws CDIException {
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int frameNum = stackframe.getLevel();
        MIStackSelectFrame frame = factory.createMIStackSelectFrame(frameNum);
        try {
            this.getCTarget().setCurrentThread(this);
            mi.postCommand(frame);
            MIInfo info = frame.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void resume() throws CDIException {
        this.getTarget().resume();
    }

    public void stepInto() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepInto();
    }

    public void stepIntoInstruction() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepIntoInstruction();
    }

    public void stepOver() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepOver();
    }

    public void stepOverInstruction() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepOverInstruction();
    }

    public void stepReturn() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().stepReturn();
    }

    public void suspend() throws CDIException {
        this.getCTarget().setCurrentThread(this);
        this.getTarget().suspend();
    }

    public boolean equals(ICDIThread thread) {
        if (thread instanceof CThread) {
            CThread cthread = (CThread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }
}

