/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointEvent;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));

    public void update(Observable o, Object arg) {
        MIEvent miEvent = (MIEvent)arg;
        CSession session = this.getCSession();
        Object cdiEvent = null;
        if (miEvent instanceof MIBreakpointEvent || miEvent instanceof MIFunctionFinishedEvent || miEvent instanceof MILocationReachedEvent || miEvent instanceof MISignalEvent || miEvent instanceof MISteppingRangeEvent || miEvent instanceof MIWatchpointEvent) {
            this.processSuspendedEvent(miEvent);
            cdiEvent = new SuspendedEvent(session, miEvent);
        } else if (miEvent instanceof MIRunningEvent) {
            cdiEvent = new ResumedEvent(session, (MIRunningEvent)miEvent);
        } else if (miEvent instanceof MIVarChangedEvent) {
            MIVarChangedEvent eventChanged = (MIVarChangedEvent)miEvent;
            cdiEvent = eventChanged.isInScope() ? new ChangedEvent(session, (MIVarChangedEvent)miEvent) : new DestroyedEvent(session, (MIVarChangedEvent)miEvent);
        } else if (miEvent instanceof MIThreadExitEvent) {
            cdiEvent = new DestroyedEvent(session, (MIThreadExitEvent)miEvent);
        } else if (miEvent instanceof MIInferiorExitEvent) {
            cdiEvent = new ExitedEvent(session, (MIInferiorExitEvent)miEvent);
        } else if (miEvent instanceof MIGDBExitEvent) {
            cdiEvent = new DestroyedEvent(session);
        }
        this.fireEvent((ICDIEvent)cdiEvent);
    }

    public EventManager(CSession session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(ICDIEventListener listener) {
        this.list.remove(listener);
    }

    private void fireEvent(ICDIEvent cdiEvent) {
        if (cdiEvent != null) {
            ICDIEventListener[] listeners = this.list.toArray(new ICDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvent(cdiEvent);
                ++i;
            }
        }
    }

    void processSuspendedEvent(MIEvent event) {
        int threadId = 0;
        CTarget target = this.getCSession().getCTarget();
        if (event instanceof MIBreakpointEvent) {
            MIBreakpointEvent breakEvent = (MIBreakpointEvent)event;
            threadId = breakEvent.getThreadId();
        } else if (event instanceof MIWatchpointEvent) {
            MIWatchpointEvent watchEvent = (MIWatchpointEvent)event;
            threadId = watchEvent.getThreadId();
        } else if (event instanceof MISteppingRangeEvent) {
            MISteppingRangeEvent rangeEvent = (MISteppingRangeEvent)event;
            threadId = rangeEvent.getThreadId();
        } else if (event instanceof MISignalEvent) {
            MISignalEvent sigEvent = (MISignalEvent)event;
            threadId = sigEvent.getThreadId();
        } else if (event instanceof MILocationReachedEvent) {
            MILocationReachedEvent locEvent = (MILocationReachedEvent)event;
            threadId = locEvent.getThreadId();
        } else if (event instanceof MIFunctionFinishedEvent) {
            MIFunctionFinishedEvent funcEvent = (MIFunctionFinishedEvent)event;
            threadId = funcEvent.getThreadId();
        }
        target.updateState(threadId);
        VariableManager varMgr = this.getCSession().getVariableManager();
        try {
            varMgr.update();
        }
        catch (CDIException e) {
            System.out.println((Object)e);
        }
    }

    void processRunningEvent() {
        this.getCSession().getCTarget();
    }
}

