/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.cdi.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.cdi.EndSteppingRange;
import org.eclipse.cdt.debug.mi.core.cdi.Signal;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointEvent;

public class SuspendedEvent
implements ICDISuspendedEvent {
    MIEvent event;
    CSession session;

    public SuspendedEvent(CSession s, MIEvent e) {
        this.session = s;
        this.event = e;
    }

    public ICDISessionObject getReason() {
        if (this.event instanceof MIBreakpointEvent || this.event instanceof MIWatchpointEvent) {
            MIBreakpointEvent breakEvent = (MIBreakpointEvent)this.event;
            int number = breakEvent.getNumber();
            BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
            Breakpoint point = mgr.getBreakpoint(number);
            if (point != null) {
                return point;
            }
        } else {
            if (this.event instanceof MISteppingRangeEvent) {
                return new EndSteppingRange(this.session);
            }
            if (this.event instanceof MISignalEvent) {
                return new Signal(this.session, (MISignalEvent)this.event);
            }
            if (this.event instanceof MILocationReachedEvent) {
                return new EndSteppingRange(this.session);
            }
            if (this.event instanceof MIFunctionFinishedEvent) {
                return new EndSteppingRange(this.session);
            }
        }
        return this.session;
    }

    public ICDIObject getSource() {
        CTarget target = this.session.getCTarget();
        int threadId = 0;
        if (this.event instanceof MIBreakpointEvent) {
            MIBreakpointEvent breakEvent = (MIBreakpointEvent)this.event;
            threadId = breakEvent.getThreadId();
        } else if (this.event instanceof MIWatchpointEvent) {
            MIWatchpointEvent watchEvent = (MIWatchpointEvent)this.event;
            threadId = watchEvent.getThreadId();
        } else if (this.event instanceof MISteppingRangeEvent) {
            MISteppingRangeEvent rangeEvent = (MISteppingRangeEvent)this.event;
            threadId = rangeEvent.getThreadId();
        } else if (this.event instanceof MISignalEvent) {
            MISignalEvent sigEvent = (MISignalEvent)this.event;
            threadId = sigEvent.getThreadId();
        } else if (this.event instanceof MILocationReachedEvent) {
            MILocationReachedEvent locEvent = (MILocationReachedEvent)this.event;
            threadId = locEvent.getThreadId();
        } else if (this.event instanceof MIFunctionFinishedEvent) {
            MIFunctionFinishedEvent funcEvent = (MIFunctionFinishedEvent)this.event;
            threadId = funcEvent.getThreadId();
        }
        try {
            ICDIThread[] cthreads = target.getThreads();
            int i = 0;
            while (i < cthreads.length) {
                if (((CThread)cthreads[i]).getId() == threadId) {
                    return cthreads[i];
                }
                ++i;
            }
        }
        catch (CDIException cDIException) {}
        return target;
    }
}

