/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;

public class Value
extends CObject
implements ICDIValue {
    Variable variable;

    public Value(Variable v) {
        super(v.getCTarget());
        this.variable = v;
    }

    public String getTypeName() throws CDIException {
        return this.variable.getTypeName();
    }

    public String getValueString() throws CDIException {
        String result = "";
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarEvaluateExpression var = factory.createMIVarEvaluateExpression(this.variable.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarEvaluateExpressionInfo info = var.getMIVarEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            result = info.getValue();
        }
        catch (MIException mIException) {}
        return result;
    }

    public ICDIVariable[] getVariables() throws CDIException {
        Variable[] variables = null;
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.variable.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            MIVar[] vars = info.getMIVars();
            variables = new Variable[vars.length];
            int i = 0;
            while (i < vars.length) {
                variables[i] = new Variable(this.variable.getStackFrame(), vars[i].getExp(), vars[i]);
                ++i;
            }
        }
        catch (MIException mIException) {}
        return variables;
    }
}

