/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.Value;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public class Variable
extends CObject
implements ICDIVariable {
    MIVar miVar;
    String name;
    Value value;
    StackFrame stack;

    public Variable(StackFrame stackframe, String n, MIVar v) {
        super(stackframe.getCTarget());
        this.stack = stackframe;
        this.name = n;
        this.miVar = v;
    }

    StackFrame getStackFrame() {
        return this.stack;
    }

    MIVar getMIVar() {
        return this.miVar;
    }

    public String getName() throws CDIException {
        return this.name;
    }

    public String getTypeName() throws CDIException {
        return this.miVar.getType();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            this.value = new Value(this);
        }
        return this.value;
    }

    public void setValue(ICDIValue value) throws CDIException {
        this.setValue(value.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.miVar.getVarName(), expression);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public boolean isEditable() throws CDIException {
        MISession mi = this.getCTarget().getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarShowAttributes var = factory.createMIVarShowAttributes(this.miVar.getVarName());
        try {
            mi.postCommand(var);
            MIVarShowAttributesInfo info = var.getMIVarShowAttributesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.isEditable();
        }
        catch (MIException e) {
            throw new CDIException(e.toString());
        }
    }

    public boolean equals(ICDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.miVar.getVarName().equals(variable.getMIVar().getVarName());
        }
        return super.equals(var);
    }
}

