/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;

public class MIDataListRegisterValues
extends MICommand {
    public MIDataListRegisterValues(int fmt) {
        this(fmt, null);
    }

    public MIDataListRegisterValues(int fmt, int[] regnos) {
        super("-data-list-register-values");
        String format = "x";
        switch (fmt) {
            case 5: {
                format = "N";
                break;
            }
            case 4: {
                format = "r";
                break;
            }
            case 3: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            default: {
                format = "x";
            }
        }
        this.setOptions(new String[]{format});
        if (regnos != null && regnos.length > 0) {
            String[] array = new String[regnos.length];
            int i = 0;
            while (i < regnos.length) {
                array[i] = Integer.toString(regnos[i]);
                ++i;
            }
            this.setParameters(array);
        }
    }

    public MIInfo getMIInfo() throws MIException {
        MIDataListRegisterValuesInfo info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MIDataListRegisterValuesInfo(out)).isError()) {
            throw new MIException(info.getErrorMsg());
        }
        return info;
    }
}

