/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakpointEvent
extends MIEvent {
    int bkptno;
    int threadId;
    MIFrame frame;
    MIExecAsyncOutput exec;
    MIResultRecord rr;

    public MIBreakpointEvent(MIExecAsyncOutput record) {
        this.exec = record;
        this.parse();
    }

    public MIBreakpointEvent(MIResultRecord record) {
        this.rr = record;
        this.parse();
    }

    public int getNumber() {
        return this.bkptno;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.bkptno).append('\n');
        buffer.append("thread-id=").append(this.threadId).append('\n');
        buffer.append(this.frame.toString());
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("bkptno")) {
                    try {
                        this.bkptno = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("thread-id")) {
                    try {
                        this.threadId = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

