/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIAsm {
    long address;
    String func = "";
    long offset;
    String inst = "";
    int line;
    String file = "";

    public MIAsm(MITuple tuple) {
        this.parse(tuple);
    }

    public long getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getInstruction() {
        return this.inst;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.file.length() > 0) {
            buffer.append("line=\"").append(this.line);
            buffer.append("file=\"" + this.file + "\",");
            buffer.append("line_asm_insn=[");
        }
        buffer.append('{');
        buffer.append("address=\"" + Long.toHexString(this.address) + "\"");
        buffer.append(",func-name=\"" + this.func + "\"");
        buffer.append(",offset=\"").append(this.offset).append('\"');
        buffer.append(",inst=\"" + this.inst + "\"");
        buffer.append('}');
        if (this.file.length() > 0) {
            buffer.append(']');
        }
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MITuple) {
                this.parse((MITuple)value);
            } else {
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getCString();
                }
                if (var.equals("address")) {
                    try {
                        this.address = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("func-name")) {
                    this.func = str;
                } else if (var.equals("offset")) {
                    try {
                        this.offset = Long.decode(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("inst")) {
                    this.inst = str;
                } else if (var.equals("line")) {
                    try {
                        this.line = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("file")) {
                    this.file = str;
                }
            }
            ++i;
        }
    }
}

