/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIDataListRegisterNamesInfo
extends MIInfo {
    String[] names;

    public MIDataListRegisterNamesInfo(MIOutput rr) {
        super(rr);
    }

    String[] getRegistersNames() {
        if (this.names == null) {
            this.parse();
        }
        return this.names;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("register-names") && (value = results[i].getMIValue()) instanceof MIList) {
                    this.parseRegisters((MIList)value, aList);
                }
                ++i;
            }
        }
        this.names = aList.toArray(new String[aList.size()]);
    }

    void parseRegisters(MIList list, List aList) {
        MIValue[] values = list.getMIValues();
        int i = 0;
        while (i < values.length) {
            String str;
            if (values[i] instanceof MIConst && (str = ((MIConst)values[i]).getCString()) != null && str.length() > 0) {
                aList.add(str);
            }
            ++i;
        }
    }
}

