/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.IBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class BuildInfoFactory {
    public static final String LOCATION = "buildLocation";
    public static final String FULL_ARGUMENTS = "buildFullArguments";
    public static final String INCREMENTAL_ARGUMENTS = "buildIncrementalArguments";
    public static final String STOP_ON_ERROR = "stopOnError";
    public static final String DEFAULT_BUILD_CMD = "useDefaultBuildCmd";

    public static IBuildInfo create() {
        return new Preference();
    }

    public static IBuildInfo create(IProject project) {
        return new Property((IResource)project);
    }

    public static abstract class Store
    implements IBuildInfo {
        public String getBuildLocation() {
            if (this.isDefaultBuildCmd()) {
                IExtensionPoint extension;
                CCorePlugin plugin = CCorePlugin.getDefault();
                if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("CBuildCommand")) != null) {
                    IExtension[] extensions = extension.getExtensions();
                    int i = 0;
                    while (i < extensions.length) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            String command = configElements[j].getAttribute("command");
                            if (command != null) {
                                return command;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return "make";
            }
            return this.getString(BuildInfoFactory.LOCATION);
        }

        public String getFullBuildArguments() {
            return this.getString(BuildInfoFactory.FULL_ARGUMENTS);
        }

        public String getIncrementalBuildArguments() {
            return this.getString(BuildInfoFactory.INCREMENTAL_ARGUMENTS);
        }

        public boolean isStopOnError() {
            return this.getBoolean(BuildInfoFactory.STOP_ON_ERROR);
        }

        public void setBuildLocation(String location) {
            this.putValue(BuildInfoFactory.LOCATION, location);
        }

        public void setFullBuildArguments(String arguments) {
            this.putValue(BuildInfoFactory.FULL_ARGUMENTS, arguments);
        }

        public void setIncrementalBuildArguments(String arguments) {
            this.putValue(BuildInfoFactory.INCREMENTAL_ARGUMENTS, arguments);
        }

        public void setStopOnError(boolean on) {
            this.putValue(BuildInfoFactory.STOP_ON_ERROR, new Boolean(on).toString());
        }

        public boolean isDefaultBuildCmd() {
            if (this.getString(BuildInfoFactory.DEFAULT_BUILD_CMD) == null) {
                return true;
            }
            return this.getBoolean(BuildInfoFactory.DEFAULT_BUILD_CMD);
        }

        public void setUseDefaultBuildCmd(boolean on) {
            this.putValue(BuildInfoFactory.DEFAULT_BUILD_CMD, new Boolean(on).toString());
        }

        public boolean getBoolean(String property) {
            return Boolean.valueOf(this.getString(property));
        }

        public void putValue(String name, String value) {
        }

        public String getString(String property) {
            return null;
        }
    }

    public static class Preference
    extends Store {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();

        public void putValue(String name, String value) {
            this.prefs.setValue(name, value);
        }

        public String getString(String property) {
            return this.prefs.getString(property);
        }

        public void setDefault(String name, String def) {
            this.prefs.setDefault(name, def);
        }
    }

    public static class Property
    extends Store {
        private IResource resource;

        public Property(IResource resource) {
            this.resource = resource;
        }

        public void putValue(String name, String value) {
            QualifiedName qName = new QualifiedName("org.eclipse.cdt.core", name);
            try {
                this.resource.setPersistentProperty(qName, value);
            }
            catch (CoreException coreException) {}
        }

        public String getString(String property) {
            QualifiedName qName = new QualifiedName("org.eclipse.cdt.core", property);
            try {
                return this.resource.getPersistentProperty(qName);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public void setDefault(String name, String def) {
        }
    }
}

