/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICProjectDescriptor;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.CProjectDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CCorePlugin
extends Plugin {
    public static final int STATUS_CDTPROJECT_EXISTS = 1;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.CCorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable e) {
        CCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public static void log(IStatus status) {
        CCorePlugin.getDefault().getLog().log(status);
    }

    public CCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgCPlugin = this;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        this.getCoreModel();
        this.getIndexModel();
    }

    public IConsole getConsole() throws CoreException {
        IConsole consoleDocument = null;
        IExtensionPoint extension = this.getDescriptor().getExtensionPoint("CBuildConsole");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                consoleDocument = (IConsole)configElements[0].createExecutableExtension("class");
                ++i;
            }
        }
        if (consoleDocument == null) {
            return new IConsole(){

                public void clear() {
                }

                public void start(IProject project) {
                }

                public ConsoleOutputStream getOutputStream() {
                    return new ConsoleOutputStream();
                }
            };
        }
        return consoleDocument;
    }

    public CoreModel getCoreModel() {
        return CoreModel.getDefault();
    }

    public IndexModel getIndexModel() {
        return IndexModel.getDefault();
    }

    public ICProjectDescriptor getCProjectDescription(IProject project) throws CoreException {
        return CProjectDescriptor.getDescription(project);
    }

    public void mapCProjectOwner(IProject project, String id) throws CoreException {
        CProjectDescriptor.configure(project, id);
    }

    public IProject createCProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Creating C Project", 3);
        if (!projectHandle.exists()) {
            projectHandle.create(description, monitor);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        projectHandle.open(monitor);
        CProjectNature.addCNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.mapCProjectOwner(projectHandle, projectID);
        return projectHandle;
    }

    public void convertProjectFromCtoCC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle != null && projectHandle.hasNature("org.eclipse.cdt.core.cnature") && !projectHandle.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature(projectHandle, monitor);
            if (projectID != null) {
                this.mapCProjectOwner(projectHandle, projectID);
            }
        }
    }

    public void convertProjectFromCtoCC(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        this.convertProjectFromCtoCC(projectHandle, monitor, null);
    }

    public void addDefaultCBuilder(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        CProjectNature.addCBuildSpec(projectHandle, monitor);
    }

    public void convertProjectToC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectHandle.getFullPath());
        this.createCProject(description, projectHandle, monitor, projectID);
        this.addDefaultCBuilder(projectHandle, monitor);
    }

    public void convertProjectToCC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        this.createCProject(projectHandle.getDescription(), projectHandle, monitor, projectID);
        this.convertProjectFromCtoCC(projectHandle, monitor);
        this.addDefaultCBuilder(projectHandle, monitor);
    }
}

