/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommandLauncher {
    public static final int COMMAND_CANCELED = 1;
    public static final int ILLEGAL_COMMAND = -1;
    public static final int OK = 0;
    protected Process fProcess = null;
    protected boolean fShowCommand = false;
    protected String[] fCommandArgs;
    protected String fErrorMessage;
    protected static final long DELAY = 50L;

    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    public Properties getEnvironment() {
        return EnvironmentReader.getEnvVars();
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory) {
        try {
            this.fCommandArgs = this.constructCommandArray(commandPath.toOSString(), args);
            this.fProcess = ProcessFactory.getFactory().exec(this.fCommandArgs, env, changeToDirectory.toFile());
            this.fErrorMessage = "";
        }
        catch (IOException e) {
            this.fErrorMessage = e.getMessage();
            this.fProcess = null;
        }
        return this.fProcess;
    }

    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.fShowCommand) {
            this.printCommandLine(this.fCommandArgs, out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        if (this.fShowCommand) {
            this.printCommandLine(this.fCommandArgs, out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, out, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return state;
    }

    protected void printCommandLine(String[] commandArgs, OutputStream os) {
        if (os != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < commandArgs.length) {
                buf.append(commandArgs[i]);
                buf.append(' ');
                ++i;
            }
            buf.append('\n');
            try {
                os.write(buf.toString().getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }
}

