/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class MakeUtil {
    static final String MAKE_GOALS = "goals";
    static final String MAKE_DIR = "buildir";
    static final String MAKE_CONSOLE_MODE = "consoleMode";
    static final String TARGET_ID = "org.eclipse.cdt.make";

    public static String[] decodeTargets(String property) {
        BufferedReader reader = new BufferedReader(new StringReader(property));
        ArrayList<String> l = new ArrayList<String>(5);
        try {
            String line = reader.readLine();
            while (line != null && !"".equals(line)) {
                l.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {}
        String[] result = new String[l.size()];
        return l.toArray(result);
    }

    public static String encodeTargets(String[] targets) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] != null) {
                buf.append(targets[i]);
                buf.append("\n");
            }
            ++i;
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    public static QualifiedName getQualifiedNameTarget() {
        return new QualifiedName(TARGET_ID, MAKE_GOALS);
    }

    public static QualifiedName getQualifiedNameDir() {
        return new QualifiedName(TARGET_ID, MAKE_DIR);
    }

    public static QualifiedName getQualifiedNameConsoleMode() {
        return new QualifiedName(TARGET_ID, MAKE_CONSOLE_MODE);
    }

    public static String getSessionTarget(IResource resource) {
        try {
            String property = (String)resource.getSessionProperty(MakeUtil.getQualifiedNameTarget());
            if (property != null) {
                return property;
            }
        }
        catch (CoreException coreException) {}
        return new String();
    }

    public static void setSessionTarget(IResource resource, String target) {
        try {
            resource.setSessionProperty(MakeUtil.getQualifiedNameTarget(), (Object)target);
        }
        catch (CoreException coreException) {}
    }

    public static void removeSessionTarget(IResource resource) {
        MakeUtil.setSessionTarget(resource, null);
    }

    public static String getSessionBuildDir(IResource resource) {
        try {
            String dir = (String)resource.getSessionProperty(MakeUtil.getQualifiedNameDir());
            if (dir != null) {
                return dir;
            }
        }
        catch (CoreException coreException) {}
        return new String();
    }

    public static void setSessionBuildDir(IResource resource, String dir) {
        try {
            resource.setSessionProperty(MakeUtil.getQualifiedNameDir(), (Object)dir);
        }
        catch (CoreException coreException) {}
    }

    public static void removeSessionBuildDir(IResource resource) {
        MakeUtil.setSessionBuildDir(resource, null);
    }

    public static String[] getPersistentTargets(IResource resource) {
        try {
            String property = resource.getPersistentProperty(MakeUtil.getQualifiedNameTarget());
            if (property != null) {
                return MakeUtil.decodeTargets(property);
            }
        }
        catch (CoreException coreException) {}
        return new String[0];
    }

    public static void setPersistentTargets(IResource resource, String[] targets) {
        String property = null;
        if (targets != null) {
            property = MakeUtil.encodeTargets(targets);
        }
        try {
            resource.setPersistentProperty(MakeUtil.getQualifiedNameTarget(), property);
        }
        catch (CoreException coreException) {}
    }

    public static void setSessionConsoleMode(IResource resource, boolean mode) {
        try {
            resource.setSessionProperty(MakeUtil.getQualifiedNameConsoleMode(), (Object)new Boolean(mode));
        }
        catch (CoreException coreException) {}
    }

    public static boolean getSessionConsoleMode(IResource resource) {
        try {
            Boolean b = (Boolean)resource.getSessionProperty(MakeUtil.getQualifiedNameConsoleMode());
            if (b != null) {
                return b;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public static void addPersistentTarget(IResource resource, String target) {
        String[] targets = MakeUtil.getPersistentTargets(resource);
        int i = 0;
        while (i < targets.length) {
            if (targets[i].equals(target)) {
                return;
            }
            ++i;
        }
        String[] newTargets = new String[targets.length + 1];
        System.arraycopy(targets, 0, newTargets, 0, targets.length);
        newTargets[targets.length] = target;
        MakeUtil.setPersistentTargets(resource, newTargets);
    }

    public static void removePersistentTarget(IResource resource, String target) {
        String[] targets = MakeUtil.getPersistentTargets(resource);
        String[] newTargets = new String[targets.length];
        int i = 0;
        while (i < targets.length) {
            if (!targets[i].equals(target)) {
                newTargets[i] = targets[i];
            }
            ++i;
        }
        MakeUtil.setPersistentTargets(resource, newTargets);
    }

    private MakeUtil() {
    }
}

