/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICProjectDescriptor;
import org.eclipse.cdt.core.ICProjectOwnerInfo;
import org.eclipse.cdt.internal.core.CProjectOwner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CProjectDescriptor
implements ICProjectDescriptor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ICProjectOwnerInfo fOwner;
    private IProject fProject;
    private String fPlatform;
    private static final String PROJECT_DESCRIPTION = "cdtproject";
    private static final String PROJECT_PLATFORM = "platform";

    private CProjectDescriptor(IProject project, String id) throws CoreException {
        IPath descriptionPath;
        boolean isDefaultLocation;
        this.fPlatform = "*";
        this.fProject = project;
        this.fOwner = new CProjectOwner(id);
        IPath projectLocation = project.getDescription().getLocation();
        boolean bl = isDefaultLocation = projectLocation == null;
        if (isDefaultLocation) {
            projectLocation = this.getProjectDefaultLocation(project);
        }
        if ((descriptionPath = projectLocation.append(".cdtproject")).toFile().exists()) {
            CCorePlugin.getDefault();
            Status status = new Status(2, "org.eclipse.cdt.core", 1, "CDTProject already exisits", null);
            throw new CoreException((IStatus)status);
        }
    }

    private CProjectDescriptor(IProject project) throws CoreException {
        block15: {
            IPath descriptionPath;
            boolean isDefaultLocation;
            this.fPlatform = "*";
            this.fProject = project;
            FileInputStream file = null;
            IPath projectLocation = project.getDescription().getLocation();
            boolean bl = isDefaultLocation = projectLocation == null;
            if (isDefaultLocation) {
                projectLocation = this.getProjectDefaultLocation(project);
            }
            if (!(descriptionPath = projectLocation.append(".cdtproject")).toFile().exists()) {
                CCorePlugin.getDefault();
                Status status = new Status(4, "org.eclipse.cdt.core", -1, "CDTProject file not found", null);
                throw new CoreException((IStatus)status);
            }
            try {
                try {
                    file = new FileInputStream(projectLocation.toFile());
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = parser.parse(file);
                    Node node = document.getFirstChild();
                    if (node.getNodeName().equals(PROJECT_DESCRIPTION)) {
                        this.fOwner = this.readProjectDescription(node);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {}
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var9_12 = null;
            if (file == null) break block15;
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected IPath getProjectDefaultLocation(IProject project) {
        return Platform.getLocation().append(project.getFullPath());
    }

    public ICProjectOwnerInfo getProjectOwner() {
        return this.fOwner;
    }

    public String getPlatform() {
        return this.fPlatform;
    }

    protected String getString(Node target, String tagName) {
        Node node = this.searchNode(target, tagName);
        return node != null ? (node.getFirstChild() == null ? null : node.getFirstChild().getNodeValue()) : null;
    }

    protected String[] getStrings(Node target) {
        if (target == null) {
            return null;
        }
        NodeList list = target.getChildNodes();
        if (list.getLength() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                result.add((String)this.read(node.getChildNodes().item(0)));
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected Object read(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: 
            case 3: {
                String value = node.getNodeValue();
                return value == null ? null : value.trim();
            }
        }
        return node.toString();
    }

    private ICProjectOwnerInfo readProjectDescription(Node node) {
        CProjectOwner owner = null;
        NamedNodeMap attrib = node.getAttributes();
        try {
            owner = new CProjectOwner(attrib.getNamedItem("id").getNodeValue());
        }
        catch (CoreException coreException) {
            return null;
        }
        this.fPlatform = this.getString(node, PROJECT_PLATFORM);
        return owner;
    }

    protected Node searchNode(Node target, String tagName) {
        NodeList list = target.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(tagName)) {
                return list.item(i);
            }
            ++i;
        }
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void saveInfo() throws CoreException {
        String xml;
        try {
            xml = this.getAsXML();
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        IFile rscFile = this.getProject().getFile(".cdtproject");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        if (rscFile.exists()) {
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    protected String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }

    protected String getAsXML() throws IOException {
        DocumentImpl doc = new DocumentImpl();
        Element configRootElement = doc.createElement(PROJECT_DESCRIPTION);
        doc.appendChild(configRootElement);
        configRootElement.setAttribute("id", this.fOwner.getID());
        Element element = this.createBuilderElement((Document)doc);
        if (element != null) {
            configRootElement.appendChild(element);
        }
        return this.serializeDocument((Document)doc);
    }

    protected Element createBuilderElement(Document doc) {
        return null;
    }

    public static synchronized ICProjectDescriptor getDescription(IProject project) throws CoreException {
        return new CProjectDescriptor(project);
    }

    public static synchronized void configure(IProject project, String id) throws CoreException {
        CProjectDescriptor cproject;
        try {
            cproject = new CProjectDescriptor(project, id);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.getCode() == 1) {
                return;
            }
            throw e;
        }
        CProjectOwner cowner = new CProjectOwner(id);
        cowner.configure(project, cproject);
        cproject.saveInfo();
    }
}

