/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICProjectDescriptor;
import org.eclipse.cdt.core.ICProjectOwner;
import org.eclipse.cdt.core.ICProjectOwnerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CProjectOwner
implements ICProjectOwnerInfo {
    String pluginId;
    IExtension extension;

    public CProjectOwner(String id) throws CoreException {
        this.pluginId = id;
        IExtensionPoint extpoint = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("CProjectOwner");
        if (extpoint == null) {
            CCorePlugin.getDefault();
            Status status = new Status(4, "org.eclipse.cdt.core", -1, "Invalid CDTProject owner ID", null);
            throw new CoreException((IStatus)status);
        }
        this.extension = extpoint.getExtension(this.pluginId);
    }

    public String getID() {
        return this.pluginId;
    }

    public String getName() {
        return this.extension == null ? null : this.extension.getLabel();
    }

    public String[] getPlatforms() {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        String[] platforms = new String[element.length];
        int i = 0;
        while (i < element.length) {
            platforms[i] = element[i].getAttribute("id");
            ++i;
        }
        return platforms;
    }

    public String getPlatformName(String platform) {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        String[] cfr_ignored_0 = new String[element.length];
        int i = 0;
        while (i < element.length) {
            if (platform.equals(element[i].getAttribute("id"))) {
                return element[i].getAttribute("name");
            }
            ++i;
        }
        return "";
    }

    public String[] getArchitectures(String platform) {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        String[] cfr_ignored_0 = new String[element.length];
        int i = 0;
        while (i < element.length) {
            if (platform.equals(element[i].getAttribute("id"))) {
                StringTokenizer stoken = new StringTokenizer(element[i].getAttribute("architecture"), ",");
                String[] archs = new String[stoken.countTokens()];
                int j = 0;
                while (j < archs.length) {
                    archs[i] = stoken.nextToken();
                    ++j;
                }
            }
            ++i;
        }
        return new String[0];
    }

    void configure(IProject project, ICProjectDescriptor cproject) throws CoreException {
        IConfigurationElement[] element = this.extension.getConfigurationElements();
        int i = 0;
        while (i < element.length) {
            if (element[i].getName().equalsIgnoreCase("run")) {
                ICProjectOwner owner = (ICProjectOwner)element[i].createExecutableExtension("class");
                owner.configure(cproject);
                return;
            }
            ++i;
        }
        CCorePlugin.getDefault();
        Status status = new Status(4, "org.eclipse.cdt.core", -1, "Invalid CDTProject owner extension", null);
        throw new CoreException((IStatus)status);
    }
}

