/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CommonMkInfo {
    public static final String COMMON_MK = "common.mk";
    IPath dir;
    long modification;
    IPath[] includePaths = new IPath[0];
    IPath[] libs = new IPath[0];
    IPath[] libPaths = new IPath[0];

    public CommonMkInfo(IPath dir) {
        this.dir = dir;
        this.modification = 0L;
    }

    public CommonMkInfo() {
        this.dir = new Path("");
        String def = EnvironmentReader.getEnvVar("QNX_TARGET");
        if (def != null) {
            Path defaultPath = new Path(def);
            this.includePaths = new IPath[]{defaultPath.append("/usr/include")};
            this.libPaths = new IPath[]{defaultPath.append("/usr/lib"), defaultPath.append("/x86/usr/lib")};
        }
        this.libs = new IPath[]{new Path("libc.so")};
    }

    public IPath[] getIncludePaths() {
        this.parse();
        return this.includePaths;
    }

    public IPath[] getLibs() {
        boolean hasLibC = false;
        this.parse();
        int i = 0;
        while (i < this.libs.length) {
            String name = this.libs[i].toOSString();
            if (name.indexOf(47) == -1 && name.indexOf(58) == -1 && name.indexOf(46) == -1 && !name.startsWith("lib")) {
                this.libs[i] = new Path("lib" + name + ".so");
            }
            if (this.libs[i].toOSString().equals("libc.so")) {
                hasLibC = true;
            }
            ++i;
        }
        if (!hasLibC) {
            IPath[] newlibs = new IPath[this.libs.length + 1];
            int i2 = 0;
            while (i2 < this.libs.length) {
                newlibs[i2] = this.libs[i2];
                ++i2;
            }
            newlibs[i2] = new Path("libc.so");
            this.libs = newlibs;
        }
        return this.libs;
    }

    public IPath[] getLibPaths() {
        this.parse();
        return this.libPaths;
    }

    public boolean hasChanged() {
        File prj = new File(this.dir.toOSString());
        File common = new File(prj, COMMON_MK);
        if (!prj.exists() || prj.isFile() || !common.exists()) {
            return false;
        }
        long modif = common.lastModified();
        return modif > this.modification;
    }

    void parse() {
        File makefile = null;
        try {
            try {
                if (this.hasChanged()) {
                    File prj = new File(this.dir.toOSString());
                    File common = new File(prj, COMMON_MK);
                    this.modification = common.lastModified();
                    makefile = File.createTempFile("QMakefile", null, prj);
                    FileOutputStream fout = new FileOutputStream(makefile);
                    DataOutputStream out = new DataOutputStream(fout);
                    out.writeBytes("LIST=OS CPU VARIANT\n");
                    out.writeBytes("include common.mk\n");
                    out.writeBytes("\n");
                    out.writeBytes("LIBS:\n");
                    out.writeBytes("\t@echo $(LIBS)\n");
                    out.writeBytes("\n");
                    out.writeBytes("INCVPATH:\n");
                    out.writeBytes("\t@echo $(INCVPATH)\n");
                    out.writeBytes("\n");
                    out.writeBytes("SRCVPATH:\n");
                    out.writeBytes("\t@echo $(SRCVPATH)\n");
                    out.writeBytes("\n");
                    out.writeBytes("LIBVPATH:\n");
                    out.writeBytes("\t@echo $(LIBVPATH)\n");
                    out.writeBytes("\n");
                    out.flush();
                    out.close();
                    Properties envp = EnvironmentReader.getEnvVars();
                    envp.setProperty("OS", "nto");
                    envp.setProperty("CPU", "x86");
                    IPath[] incVPath = this.spawn("INCVPATH", envp, makefile, prj);
                    this.parseIncVPath(incVPath);
                    IPath[] libNames = this.spawn("LIBS", envp, makefile, prj);
                    this.parseLibs(libNames);
                    IPath[] libVPath = this.spawn("LIBVPATH", envp, makefile, prj);
                    this.parseLibVPath(libVPath);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (makefile != null) {
                    makefile.delete();
                }
            }
            catch (SecurityException securityException) {}
            throw throwable;
        }
        Object var10_12 = null;
        try {
            if (makefile != null) {
                makefile.delete();
            }
        }
        catch (SecurityException securityException) {}
    }

    IPath[] spawn(String target, Properties envp, File makefile, File dir) {
        String[] args = new String[]{"make", "-f", makefile.getName(), target};
        BufferedReader stdout = null;
        Process make = null;
        StringBuffer buffer = new StringBuffer();
        try {
            try {
                String s;
                ArrayList<String> envList = new ArrayList<String>();
                Enumeration<?> names = envp.propertyNames();
                if (names != null) {
                    while (names.hasMoreElements()) {
                        String key = (String)names.nextElement();
                        envList.add(String.valueOf(key) + "=" + envp.getProperty(key));
                    }
                }
                String[] env = envList.toArray(new String[envList.size()]);
                make = ProcessFactory.getFactory().exec(args, env, dir);
                stdout = new BufferedReader(new InputStreamReader(make.getInputStream()));
                while ((s = stdout.readLine()) != null) {
                    buffer.append(s);
                }
                stdout.close();
            }
            catch (SecurityException securityException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (make != null) {
                make.destroy();
            }
            throw throwable;
        }
        Object var13_16 = null;
        if (make != null) {
            make.destroy();
        }
        StringTokenizer st = new StringTokenizer(buffer.toString());
        IPath[] p = new IPath[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            p[i] = new Path(st.nextToken());
            ++i;
        }
        return p;
    }

    void parseLibVPath(IPath[] array) {
        ArrayList<IPath> list = new ArrayList<IPath>(array.length);
        int i = 0;
        while (i < array.length) {
            if (array[i].toString().charAt(0) != '-') {
                list.add(array[i]);
            }
            ++i;
        }
        this.libPaths = list.toArray(new IPath[list.size()]);
    }

    void parseIncVPath(IPath[] array) {
        ArrayList<IPath> list = new ArrayList<IPath>(array.length);
        int i = 0;
        while (i < array.length) {
            if (array[i].toString().charAt(0) != '-') {
                list.add(array[i]);
            }
            ++i;
        }
        this.includePaths = list.toArray(new IPath[list.size()]);
    }

    void parseLibs(IPath[] array) {
        ArrayList<IPath> list = new ArrayList<IPath>(array.length);
        int i = 0;
        while (i < array.length) {
            if (array[i].toString().charAt(0) != '-') {
                list.add(array[i]);
            }
            ++i;
        }
        this.libs = list.toArray(new IPath[list.size()]);
    }
}

