/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ProcessClosure {
    protected static int fCounter = 0;
    protected Process fProcess;
    protected OutputStream fOutput;
    protected OutputStream fError;
    protected ReaderThread fOutputReader;
    protected ReaderThread fErrorReader;

    public ProcessClosure(Process process, OutputStream outputStream, OutputStream errorStream) {
        this.fProcess = process;
        this.fOutput = outputStream;
        this.fError = errorStream;
    }

    public void runNonBlocking() {
        ThreadGroup group = new ThreadGroup("CBuilder" + fCounter++);
        InputStream stdin = this.fProcess.getInputStream();
        InputStream stderr = this.fProcess.getErrorStream();
        this.fOutputReader = new ReaderThread(group, "OutputReader", stdin, this.fOutput);
        this.fErrorReader = new ReaderThread(group, "ErrorReader", stderr, this.fError);
        this.fOutputReader.start();
        this.fErrorReader.start();
    }

    public void runBlocking() {
        this.runNonBlocking();
        boolean finished = false;
        while (!finished) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.fProcess.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        if (!this.fOutputReader.finished()) {
            this.fOutputReader.waitFor();
        }
        if (!this.fErrorReader.finished()) {
            this.fErrorReader.waitFor();
        }
        this.fProcess = null;
        this.fOutputReader = null;
        this.fErrorReader = null;
    }

    public boolean isAlive() {
        if (this.fProcess != null) {
            if (this.fOutputReader.isAlive() && this.fErrorReader.isAlive()) {
                return true;
            }
            this.fProcess = null;
            this.fOutputReader = null;
            this.fErrorReader = null;
        }
        return false;
    }

    public void terminate() {
        if (this.fProcess != null) {
            this.fProcess.destroy();
            this.fProcess = null;
        }
    }

    protected static class ReaderThread
    extends Thread {
        private InputStream fInputStream;
        private OutputStream fOutputStream;
        private boolean fFinished = false;

        public ReaderThread(ThreadGroup group, String name, InputStream in, OutputStream out) {
            super(group, name);
            this.fOutputStream = out;
            this.fInputStream = in;
            this.setDaemon(true);
        }

        public void run() {
            try {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                    while ((line = reader.readLine()) != null) {
                        char[] array = line.toCharArray();
                        writer.write(array, 0, array.length);
                        writer.newLine();
                        writer.flush();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.fInputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    this.fOutputStream.close();
                }
                catch (IOException iOException) {}
                this.complete();
                throw throwable;
            }
            Object var5_7 = null;
            try {
                this.fInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {}
            this.complete();
        }

        public synchronized boolean finished() {
            return this.fFinished;
        }

        public synchronized void waitFor() {
            while (!this.fFinished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void complete() {
            this.fFinished = true;
            this.notify();
        }
    }
}

