/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.internal.core.index.CTagsEntry;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;

public class CTagsCmd {
    private void process(String filename, List list, IFile file) throws IOException {
        String[] args = new String[]{"ctags", "--excmd=pattern", "--format=2", "--if0=yes", "--sort=no", "--extra=q", "--fields=aiKlmnsz", "--line-directives=yes", "--sort=no", "--kind-long", "--c-types=cdefgmnpstuvx", "-f", "-", filename};
        Process ctags = ProcessFactory.getFactory().exec(args);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(ctags.getInputStream()));
        try {
            String line;
            while ((line = stdout.readLine()) != null) {
                CTagsEntry entry = new CTagsEntry(line, file);
                list.add(entry);
            }
        }
        catch (IOException iOException) {}
        try {
            stdout.close();
            ctags.getOutputStream().close();
            ctags.getErrorStream().close();
        }
        catch (IOException iOException) {}
        ctags.destroy();
    }

    public ITagEntry[] getTagEntries(IFile file, String filename) throws IOException {
        LinkedList list = new LinkedList();
        this.process(filename, list, file);
        return list.toArray(new ITagEntry[0]);
    }

    public static void main(String[] args) {
        try {
            CTagsCmd cmd = new CTagsCmd();
            ITagEntry[] entries = cmd.getTagEntries(null, args[0]);
            int i = 0;
            while (i < entries.length) {
                if (entries[i] instanceof CTagsEntry) {
                    CTagsEntry entry = (CTagsEntry)entries[i];
                    System.out.println(String.valueOf(entry.getLine()) + "\n");
                    entry.print();
                    System.out.println("\n");
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

