/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.index.TagFlags;
import org.eclipse.core.resources.IFile;

public class CTagsEntry
implements ITagEntry {
    static final String TAB_SEPARATOR = "\t";
    static final String PATTERN_SEPARATOR = ";\"";
    static final String LANGUAGE = "language";
    static final String KIND = "kind";
    static final String LINE = "line";
    static final String FILE = "file";
    static final String INHERITS = "inherits";
    static final String ACCESS = "access";
    static final String IMPLEMENTATION = "implementation";
    static final String CLASS = "class";
    final String[] NONE = new String[0];
    String tagName;
    String fileName;
    IFile file;
    String pattern;
    int lineNumber;
    HashMap tagExtensionField;
    String line;

    public CTagsEntry(String line, IFile file) {
        this.line = line;
        this.file = file;
        this.tagName = "";
        this.fileName = "";
        this.pattern = null;
        this.lineNumber = 0;
        this.tagExtensionField = new HashMap();
        this.parse();
    }

    void parse() {
        String delim = TAB_SEPARATOR;
        StringTokenizer st = new StringTokenizer(this.line, delim);
        int state = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken(delim);
            switch (state) {
                case 0: {
                    this.tagName = token;
                    break;
                }
                case 1: {
                    this.fileName = token;
                    delim = PATTERN_SEPARATOR;
                    break;
                }
                case 2: {
                    try {
                        String sub = token.substring(1);
                        if (Character.isDigit(sub.charAt(0))) {
                            this.lineNumber = Integer.parseInt(sub);
                        } else {
                            int i = sub.indexOf("/^");
                            int j = sub.lastIndexOf("$/");
                            try {
                                if (i >= 0 && j >= 0) {
                                    sub = sub.substring(i + 2, j);
                                } else if (i >= 0) {
                                    sub = sub.substring(i + 2, sub.length() - 1);
                                }
                            }
                            catch (Exception exception) {}
                            this.pattern = sub;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    delim = TAB_SEPARATOR;
                    break;
                }
                default: {
                    int i = token.indexOf(58);
                    if (i == -1) break;
                    String key = token.substring(0, i);
                    String value = token.substring(i + 1);
                    this.tagExtensionField.put(key, value);
                }
            }
            ++state;
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public IFile getIFile() {
        return this.file;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getLineNumber() {
        try {
            String sub = (String)this.tagExtensionField.get(LINE);
            if (sub != null) {
                this.lineNumber = Integer.parseInt(sub);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return this.lineNumber;
    }

    public int getKind() {
        String kind = (String)this.tagExtensionField.get(KIND);
        return TagFlags.value(kind);
    }

    public String getLanguage() {
        return (String)this.tagExtensionField.get(LANGUAGE);
    }

    public int getImplementation() {
        String impl = (String)this.tagExtensionField.get(IMPLEMENTATION);
        return TagFlags.value(impl);
    }

    public String getClassName() {
        return (String)this.tagExtensionField.get(CLASS);
    }

    public boolean hasFileScope() {
        return this.tagExtensionField.get(FILE) != null;
    }

    public String[] getInherits() {
        String base = (String)this.tagExtensionField.get(INHERITS);
        if (base != null) {
            StringTokenizer st = new StringTokenizer(base, ",");
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            return list.toArray(new String[0]);
        }
        return this.NONE;
    }

    public int getAccessControl() {
        String access = (String)this.tagExtensionField.get(ACCESS);
        return TagFlags.value(access);
    }

    public String getLine() {
        return this.line;
    }

    public static String makeTagLine(ITagEntry tagEntry) {
        String clazz;
        String impl;
        String lang;
        StringBuffer buffer = new StringBuffer();
        buffer.append(tagEntry.getTagName());
        buffer.append(TAB_SEPARATOR);
        buffer.append(tagEntry.getFileName());
        buffer.append(TAB_SEPARATOR);
        String pat = tagEntry.getPattern();
        if (pat != null) {
            buffer.append(pat);
        } else {
            buffer.append(tagEntry.getLineNumber());
        }
        buffer.append(PATTERN_SEPARATOR);
        buffer.append(TAB_SEPARATOR);
        String kind = TagFlags.value(tagEntry.getKind());
        if (kind != null) {
            buffer.append("kind:" + tagEntry.getKind());
            buffer.append(TAB_SEPARATOR);
        }
        if ((lang = tagEntry.getLanguage()) != null) {
            buffer.append("language:" + tagEntry.getLanguage());
            buffer.append(TAB_SEPARATOR);
        }
        if (tagEntry.hasFileScope()) {
            buffer.append("file:");
            buffer.append(TAB_SEPARATOR);
        }
        String[] inherits = tagEntry.getInherits();
        int i = 0;
        while (i < inherits.length) {
            if (i == 0) {
                buffer.append("inherits:");
            } else {
                buffer.append(",");
            }
            buffer.append(inherits[i]);
            ++i;
        }
        String access = TagFlags.value(tagEntry.getAccessControl());
        if (access != null) {
            buffer.append("access:" + access);
            buffer.append(TAB_SEPARATOR);
        }
        if ((impl = TagFlags.value(tagEntry.getImplementation())) != null) {
            buffer.append("implementation:" + impl);
            buffer.append(TAB_SEPARATOR);
        }
        if ((clazz = tagEntry.getClassName()) != null) {
            buffer.append("class:" + clazz);
            buffer.append(TAB_SEPARATOR);
        }
        return buffer.toString().trim();
    }

    public void print() {
        System.out.println("TagName " + this.getTagName());
        System.out.println("FileName " + this.getFileName());
        System.out.println("Pattern " + this.getPattern());
        System.out.println("LineNumber " + this.getLineNumber());
        System.out.println("Kind " + this.getKind());
        System.out.println("Language " + this.getLanguage());
        System.out.println("FileScope " + this.hasFileScope());
        String[] inherits = this.getInherits();
        int i = 0;
        while (i < inherits.length) {
            System.out.println("Inherit " + inherits[i]);
            ++i;
        }
        System.out.println("AccessControl " + this.getAccessControl());
        System.out.println("Implementation " + this.getImplementation());
        System.out.println("ClassName " + this.getClassName());
    }
}

