/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CFile;
import org.eclipse.cdt.internal.core.model.CFileInfo;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class BinaryInfo
extends CFileInfo {
    String[] needed = new String[0];
    ElfHelper.Sizes sizes = null;
    Elf.Attribute attribute = null;
    String soname = "";
    Map hash = new HashMap();
    ElfHelper elfHelper = null;

    public BinaryInfo(CElement element) {
        super(element);
    }

    public boolean isBinary() {
        return true;
    }

    public ICElement[] getChildren() {
        this.initChildren();
        return super.getChildren();
    }

    public String getCPU() {
        this.init();
        String cpu = null;
        if (this.attribute != null) {
            cpu = this.attribute.getCPU();
        }
        return cpu == null ? "" : cpu;
    }

    public boolean isSharedLib() {
        this.init();
        if (this.attribute != null) {
            return this.attribute.getType() == 2;
        }
        return false;
    }

    public boolean isExecutable() {
        this.init();
        if (this.attribute != null) {
            return this.attribute.getType() == 1;
        }
        return false;
    }

    public boolean isObject() {
        this.init();
        if (this.attribute != null) {
            return this.attribute.getType() == 3;
        }
        return false;
    }

    public boolean hasDebug() {
        this.init();
        if (this.attribute != null) {
            return this.attribute.hasDebug();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        this.init();
        return this.needed;
    }

    public long getText() {
        this.init();
        if (this.sizes != null) {
            return this.sizes.text;
        }
        return 0L;
    }

    public long getData() {
        this.init();
        if (this.sizes != null) {
            return this.sizes.data;
        }
        return 0L;
    }

    public long getBSS() {
        this.init();
        if (this.sizes != null) {
            return this.sizes.bss;
        }
        return 0L;
    }

    public String getSoname() {
        this.init();
        return this.soname;
    }

    private void addFunction(Elf.Symbol[] symbol, boolean external) {
        int i = 0;
        while (i < symbol.length) {
            CElement parent = this.getElement();
            String filename = null;
            try {
                filename = symbol[i].getFilename();
            }
            catch (IOException iOException) {}
            Function function = null;
            if (filename != null && !filename.equals("??")) {
                TranslationUnit tu = null;
                Path path = new Path(filename);
                if (this.hash.containsKey(path)) {
                    tu = (TranslationUnit)this.hash.get(path);
                } else {
                    tu = new TranslationUnit((ICElement)parent, (IPath)path);
                    this.hash.put(path, tu);
                    this.addChild(tu);
                }
                function = new Function(tu, symbol[i].toString());
                tu.addChild(function);
            } else {
                function = new Function(parent, symbol[i].toString());
                this.addChild(function);
            }
            if (function != null && !external) {
                function.getFunctionInfo().setAccessControl(8);
            }
            ++i;
        }
    }

    private void addVariable(Elf.Symbol[] symbol, boolean external) {
        int i = 0;
        while (i < symbol.length) {
            String filename = null;
            try {
                filename = symbol[i].getFilename();
            }
            catch (IOException iOException) {}
            CElement parent = this.getElement();
            Variable variable = null;
            if (filename != null && !filename.equals("??")) {
                TranslationUnit tu = null;
                Path path = new Path(filename);
                if (this.hash.containsKey(path)) {
                    tu = (TranslationUnit)this.hash.get(path);
                } else {
                    tu = new TranslationUnit((ICElement)parent, (IPath)path);
                    this.hash.put(path, tu);
                    this.addChild(tu);
                }
                variable = new Variable(tu, symbol[i].toString());
                tu.addChild(variable);
            } else {
                variable = new Variable(parent, symbol[i].toString());
                this.addChild(variable);
            }
            if (variable != null && !external) {
                variable.getVariableInfo().setAccessControl(8);
            }
            ++i;
        }
    }

    protected void init() {
        if (this.hasChanged()) {
            this.loadInfo();
        }
    }

    protected void initChildren() {
        if (this.hasChanged() || !this.isStructureKnown()) {
            this.removeChildren();
            this.loadInfoChildren();
        }
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.elfHelper != null) {
            return this.elfHelper;
        }
        CFile file = (CFile)this.getElement();
        if (file != null) {
            IPath path = ((CFile)this.getElement()).getLocation();
            if (path == null) {
                path = new Path("");
            }
            return new ElfHelper(path.toOSString());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void loadInfo() {
        try {
            ElfHelper helper = this.getElfHelper();
            Elf.Dynamic[] sharedlibs = helper.getNeeded();
            this.needed = new String[sharedlibs.length];
            int i = 0;
            while (i < sharedlibs.length) {
                this.needed[i] = sharedlibs[i].toString();
                ++i;
            }
            this.sizes = helper.getSizes();
            this.soname = helper.getSoname();
            this.attribute = helper.getElf().getAttributes();
            helper.dispose();
        }
        catch (IOException iOException) {}
    }

    protected void loadInfoChildren() {
        try {
            this.setIsStructureKnown(true);
            ElfHelper helper = this.getElfHelper();
            this.addFunction(helper.getExternalFunctions(), true);
            this.addFunction(helper.getLocalFunctions(), false);
            this.addVariable(helper.getExternalObjects(), true);
            this.addVariable(helper.getLocalObjects(), false);
            Elf.Dynamic[] sharedlibs = helper.getNeeded();
            this.needed = new String[sharedlibs.length];
            int i = 0;
            while (i < sharedlibs.length) {
                this.needed[i] = sharedlibs[i].toString();
                ++i;
            }
            this.sizes = helper.getSizes();
            this.soname = helper.getSoname();
            this.attribute = helper.getElf().getAttributes();
            helper.dispose();
        }
        catch (IOException iOException) {}
    }
}

