/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ICRoot;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CElement
extends PlatformObject
implements ICElement {
    protected int fType;
    protected ICElement fParent;
    protected CElementInfo fCElementInfo;
    protected String fName;
    protected int fStartPos;
    protected int fLength;
    protected int fIdStartPos;
    protected int fIdLength;
    protected int fStartLine;
    protected int fEndLine;
    protected CElement[] empty = new CElement[0];

    protected CElement(ICElement parent, String name, int type) {
        this.fParent = parent;
        this.fName = name;
        this.fType = type;
        this.fCElementInfo = null;
    }

    public void setElementType(int type) {
        this.fType = type;
    }

    public void setElementName(String name) {
        this.fName = name;
    }

    public void setParent(ICElement parent) {
        this.fParent = parent;
    }

    public int getElementType() {
        return this.fType;
    }

    public String getElementName() {
        return this.fName;
    }

    public ICElement getParent() {
        return this.fParent;
    }

    public IPath getPath() {
        try {
            IResource res = this.getUnderlyingResource();
            if (res != null) {
                return res.getFullPath();
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean exists() {
        try {
            return this.getCorrespondingResource() != null;
        }
        catch (CModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isStructureKnown() throws CModelException {
        return this.getElementInfo().isStructureKnown();
    }

    public ICRoot getCRoot() {
        return this.getParent().getCRoot();
    }

    public ICProject getCProject() {
        return this.getParent().getCProject();
    }

    protected void addChild(ICElement e) {
    }

    public void setPos(int startPos, int length) {
        this.fStartPos = startPos;
        this.fLength = length;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setIdPos(int startPos, int length) {
        this.fIdStartPos = startPos;
        this.fIdLength = length;
    }

    public int getIdStartPos() {
        return this.fIdStartPos;
    }

    public int getIdLength() {
        return this.fIdLength;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public void setLines(int startLine, int endLine) {
        this.fStartLine = startLine;
        this.fEndLine = endLine;
    }

    public abstract IResource getUnderlyingResource() throws CModelException;

    public abstract IResource getCorrespondingResource() throws CModelException;

    protected abstract CElementInfo createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CElement) {
            CElement other = (CElement)o;
            try {
                IResource tres = this.getCorrespondingResource();
                IResource ores = other.getCorrespondingResource();
                if (ores != null && tres != null) {
                    return tres.equals((Object)ores);
                }
            }
            catch (CModelException cModelException) {}
            if (this.fType != other.fType) {
                return false;
            }
            if (this.fName.equals(other.fName)) {
                if (this.fParent != null && this.fParent.equals(other.fParent)) {
                    return true;
                }
                if (this.fParent == null && other.fParent == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public CElementInfo getElementInfo() {
        if (this.fCElementInfo == null) {
            this.fCElementInfo = this.createElementInfo();
        }
        return this.fCElementInfo;
    }

    public String toString() {
        return this.getElementName();
    }

    public String toDebugString() {
        return String.valueOf(this.getElementName()) + " " + CElement.getTypeString(this.getElementType());
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 10: {
                return "CROOT";
            }
            case 11: {
                return "CPROJECT";
            }
            case 12: {
                return "CFOLDER";
            }
            case 13: {
                return "CFILE";
            }
            case 71: {
                return "C_FUNCTION";
            }
            case 70: {
                return "C_FUNCTION_DECLARATION";
            }
            case 74: {
                return "C_VARIABLE";
            }
            case 75: {
                return "C_VARIABLE_DECLARATION";
            }
            case 72: {
                return "C_INCLUDE";
            }
            case 77: {
                return "C_MACRO";
            }
            case 65: {
                return "C_STRUCT";
            }
            case 64: {
                return "C_CLASS";
            }
            case 66: {
                return "C_UNION";
            }
            case 69: {
                return "C_FIELD";
            }
            case 67: {
                return "C_METHOD";
            }
        }
        return "UNKNOWN";
    }

    protected void runOperation(CModelOperation operation, IProgressMonitor monitor) throws CModelException {
        CModelManager.getDefault().runOperation(operation, monitor);
    }
}

