/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CFile;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

class SourceManipulationInfo
extends CElementInfo {
    protected SourceManipulationInfo(CElement element) {
        super(element);
        this.setIsStructureKnown(true);
    }

    protected ISourceRange getSourceRange() {
        return new SourceRange(this.getElement().getStartPos(), this.getElement().getLength(), this.getElement().getIdStartPos(), this.getElement().getIdLength(), this.getElement().getStartLine(), this.getElement().getEndLine());
    }

    public String getSource() throws CModelException {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            try {
                IFile file = ((CFile)((Object)tu)).getFile();
                StringBuffer buffer = Util.getContent(file);
                return buffer.substring(this.getElement().getStartPos(), this.getElement().getStartPos() + this.getElement().getLength());
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
        }
        return "";
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement celem = this.getElement();
        while (celem != null) {
            if (celem instanceof ITranslationUnit) {
                return (ITranslationUnit)celem;
            }
            celem = celem.getParent();
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getElement().getCRoot().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        ICElement[] elements = new ICElement[]{this.getElement()};
        this.getElement().getCRoot().delete(elements, force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException("operation.nullContainer");
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getElement().getCRoot().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        if (name == null) {
            throw new IllegalArgumentException("element.nullName");
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] dests = new ICElement[]{this.getElement().getParent()};
        String[] renamings = new String[]{name};
        this.getElement().getCRoot().rename(elements, dests, renamings, force, monitor);
    }
}

