/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CFile;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TranslationUnit
extends CFile
implements ITranslationUnit {
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement parent, IFile file) {
        super(parent, file);
    }

    public TranslationUnit(ICElement parent, IPath path) {
        super(parent, path);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String name, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            ISourceRange range = ((ISourceReference)((Object)celements[i])).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public ICElement getElement(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (name.equals(celements[i].getElementName())) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public IInclude getInclude(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 72 && name.equals(celements[i].getElementName())) {
                return (IInclude)celements[i];
            }
            ++i;
        }
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 72) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String name) {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62 && name.equals(celements[i].getElementName())) {
                return (IUsing)celements[i];
            }
            ++i;
        }
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IUsing[0]);
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected void parse(InputStream in) {
        this.getTranslationUnitInfo().parse(in);
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }
}

