/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class LinePositionInputStream
extends InputStream {
    private List fLinePositions;
    private InputStream fInputStream;
    private boolean fRRead;
    private boolean fAddLine;
    private int fCurrPosition;

    public LinePositionInputStream(InputStream inputStream) throws IOException {
        this.fInputStream = inputStream;
        this.fLinePositions = new ArrayList(30);
        this.fAddLine = true;
        this.fRRead = false;
        this.fCurrPosition = 0;
    }

    public int read() throws IOException {
        int ch = this.fInputStream.read();
        if (this.fRRead && ch == 10) {
            this.fRRead = false;
        } else {
            if (this.fAddLine) {
                this.fLinePositions.add(new Integer(this.fCurrPosition));
                this.fAddLine = false;
            }
            if (ch == 10 || ch == 13) {
                this.fAddLine = true;
                this.fRRead = ch == 13;
            } else {
                this.fRRead = false;
            }
        }
        ++this.fCurrPosition;
        return ch;
    }

    public int getPosition(int line, int col) {
        --col;
        if (--line < this.fLinePositions.size()) {
            Integer lineStart = (Integer)this.fLinePositions.get(line);
            return lineStart + col;
        }
        return -1;
    }
}

