/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;

public class Spawner
extends Process {
    private int NOOP = 0;
    private int HUP = 1;
    private int INT = 2;
    private int KILL = 9;
    private int TERM = 15;
    private int pid = -1;
    private int status;
    private int[] channels = new int[3];
    OutputStream out;
    InputStream in;
    InputStream err;

    static {
        System.loadLibrary("spawner");
    }

    public Spawner(String command, boolean bNoRedirect) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        if (bNoRedirect) {
            this.exec_detached(cmdarray, new String[0], ".");
        } else {
            this.exec(cmdarray, new String[0], ".");
        }
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir) throws IOException {
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected Spawner(String command) throws IOException {
        this(command, null);
    }

    protected Spawner(String[] cmdarray) throws IOException {
        this(cmdarray, null);
    }

    protected Spawner(String[] cmdarray, String[] envp) throws IOException {
        this(cmdarray, envp, null);
    }

    protected Spawner(String cmd, String[] envp) throws IOException {
        this(cmd, envp, null);
    }

    protected Spawner(String command, String[] envp, File dir) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public int waitFor() throws InterruptedException {
        this.status = this.waitFor(this.pid);
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {}
        return this.status;
    }

    public int exitValue() {
        if (this.isRunning()) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    public void destroy() {
        this.terminate();
        if (this.isRunning()) {
            this.kill();
        }
        try {
            this.waitFor();
        }
        catch (InterruptedException interruptedException) {}
    }

    public int interrupt() {
        return this.raise(this.pid, this.INT);
    }

    public int hangup() {
        return this.raise(this.pid, this.HUP);
    }

    public int kill() {
        return this.raise(this.pid, this.KILL);
    }

    public int terminate() {
        return this.raise(this.pid, this.TERM);
    }

    public boolean isRunning() {
        return this.raise(this.pid, this.NOOP) == 0;
    }

    private void exec(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec0(cmdarray, envp, dirpath, this.channels);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
        this.in = new SpawnerInputStream(this.channels[1]);
        this.err = new SpawnerInputStream(this.channels[2]);
        this.out = new SpawnerOutputStream(this.channels[0]);
    }

    public void exec_detached(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec1(cmdarray, envp, dirpath);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    private native int exec0(String[] var1, String[] var2, String var3, int[] var4);

    private native int exec1(String[] var1, String[] var2, String var3);

    private native int raise(int var1, int var2);

    private native int waitFor(int var1);
}

