/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.cview.CLibFilter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

class ShowLibrariesAction
extends SelectionProviderAction {
    private CView cview;
    private Shell shell;

    public ShowLibrariesAction(Shell shell, CView cview, String label) {
        super((ISelectionProvider)cview.getViewer(), label);
        this.cview = cview;
        CLibFilter filter = cview.getLibraryFilter();
        this.setChecked(filter.getShowLibraries());
        this.updateToolTipText();
        this.setEnabled(true);
        this.shell = shell;
    }

    public void run() {
        CLibFilter filter = this.cview.getLibraryFilter();
        filter.setShowLibraries(this.isChecked());
        this.updateToolTipText();
        this.saveInPreferences();
        this.cview.getViewer().getControl().setRedraw(false);
        this.cview.getViewer().refresh();
        this.cview.getViewer().getControl().setRedraw(true);
    }

    private void saveInPreferences() {
        CPlugin plugin = CPlugin.getDefault();
        Boolean b = new Boolean(this.cview.getLibraryFilter().getShowLibraries());
        plugin.getPreferenceStore().putValue("showLibraries", b.toString());
    }

    private void updateToolTipText() {
        CLibFilter filter = this.cview.getLibraryFilter();
        if (filter.getShowLibraries()) {
            this.setToolTipText("Hide Referenced Libs");
        } else {
            this.setToolTipText("Show Referenced Libs");
        }
    }
}

