/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class MessageLine
extends CLabel {
    private String fMessageText;
    private String fErrorText;
    private Color fDefaultColor = this.getForeground();
    private RGB fErrorRGB;
    private Color fErrorColor;
    private static RGB fgErrorRGB = new RGB(200, 0, 0);

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    public String getErrorMessage() {
        return this.fErrorText;
    }

    public String getMessage() {
        return this.fMessageText;
    }

    public MessageLine(Composite parent, int style, RGB errorRGB) {
        super(parent, style);
        this.fErrorRGB = errorRGB;
    }

    public MessageLine(Composite parent, int style) {
        super(parent, style);
        this.fErrorRGB = fgErrorRGB;
    }

    public MessageLine(Composite parent) {
        this(parent, 16384);
    }

    public static void setErrorColor(RGB color) {
        fgErrorRGB = color;
    }

    public void setErrorMessage(String message) {
        this.fErrorText = message;
        if (message == null) {
            this.setMessage(this.fMessageText);
        } else {
            if (this.fErrorColor == null) {
                this.fErrorColor = new Color((Device)this.getDisplay(), this.fErrorRGB);
                this.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        MessageLine.this.fErrorColor.dispose();
                    }
                });
            }
            this.setForeground(this.fErrorColor);
            this.setText(message);
        }
    }

    public void setMessage(String message) {
        this.fMessageText = message;
        if (message == null) {
            message = "";
        }
        if (this.fErrorText == null) {
            this.setForeground(this.fDefaultColor);
            this.setText(message);
        }
    }
}

