/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Map;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CMarkerAnnotation
extends MarkerAnnotation
implements IProblemAnnotation {
    private boolean fIsProblemMarker;
    private IDocument fDocument;
    private int error_start = -1;
    private int error_length = 0;
    private IDebugModelPresentation fPresentation;

    public CMarkerAnnotation(IMarker marker, IDocument document) {
        super(marker);
        this.fDocument = document;
        if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
            this.fIsProblemMarker = true;
            try {
                int line;
                String var = (String)this.getMarker().getAttribute("problem.variable");
                if (var != null && this.fDocument != null && (line = this.getMarker().getAttribute("location", -1) - 1) >= 0) {
                    int position = this.fDocument.getLineOffset(line);
                    String text = this.fDocument.get(position, this.fDocument.getLineLength(line));
                    int start = 0;
                    int pos = 0;
                    while (start != -1) {
                        start = text.indexOf(var, pos);
                        if (start >= 0 && !Character.isJavaIdentifierStart(text.charAt(start + var.length()))) break;
                        pos += var.length();
                    }
                    if (start >= 0) {
                        int end = start + var.length();
                        Map map = marker.getAttributes();
                        MarkerUtilities.setCharStart((Map)map, (int)(position + start));
                        MarkerUtilities.setCharEnd((Map)map, (int)(position + end));
                        this.error_start = position + start;
                        this.error_length = end - start;
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void initialize() {
        try {
            IMarker marker = this.getMarker();
            if (MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.search.searchmarker")) {
                this.setLayer(2);
                this.setImage(SearchUI.getSearchMarkerImage());
                this.fIsProblemMarker = false;
                return;
            }
            if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.LINE_BREAKPOINT_MARKER)) {
                if (this.fPresentation == null) {
                    this.fPresentation = DebugUITools.newDebugModelPresentation();
                }
                this.setLayer(4);
                this.setImage(this.fPresentation.getImage((Object)marker));
                this.fIsProblemMarker = false;
                return;
            }
            if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
                int line;
                this.fIsProblemMarker = true;
                String var = (String)marker.getAttribute("problem.variable");
                if (var != null && this.fDocument != null && (line = marker.getAttribute("location", -1)) >= 0 && line == -1) {
                    try {
                        int position = this.fDocument.getLineOffset(line);
                        System.out.println("offset " + position);
                        String text = this.fDocument.get(position, this.fDocument.getLineLength(line));
                        System.out.println("text:" + text);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else {
                if (marker.isSubtypeOf("org.eclipse.cdt.core.problem")) {
                    this.fIsProblemMarker = true;
                }
                this.fIsProblemMarker = true;
            }
        }
        catch (CoreException coreException) {}
        super.initialize();
    }

    public String getMessage() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("message", "");
        }
        return "";
    }

    public boolean isError() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 2;
        }
        return false;
    }

    public boolean isWarning() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 1;
        }
        return false;
    }

    public boolean isTemporaryProblem() {
        return false;
    }

    public String[] getArguments() {
        String[] s = new String[]{"problem", "here"};
        return s;
    }

    public int getId() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("org.eclipse.cdt.core.problem", -1);
        }
        return 0;
    }

    public boolean isProblem() {
        return this.fIsProblemMarker;
    }

    public int getErrorStart() {
        return this.error_start;
    }

    public int getErrorLength() {
        return this.error_length;
    }
}

